/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.beans.util.DataTypeConverter;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import java.awt.FlowLayout;

public class NumberCustomizer
extends AbstractCustomizer<Number, NumericalSliderComponent> {
    private NumericalSliderComponent numberEditor;
    private DataTypeConverter<Number, ?> dataTypeConverter;

    public NumberCustomizer() {
        this("");
    }

    public NumberCustomizer(String label) {
        this.setLayout(new FlowLayout(0));
        this.numberEditor = new NumericalSliderComponent(label, 0, 0, 1000, 6);
        new PropertyChangeInvoker(this.numberEditor, this, "numberChanged");
        this.add(this.numberEditor);
        this.setEditor(this.numberEditor);
    }

    public NumberCustomizer(Number number) {
        this();
        this.setNumber(number);
    }

    public NumberCustomizer(String label, Number number) {
        this(label);
        this.setNumber(number);
    }

    public void setRange(Number minimum, Number maximum) {
        this.numberEditor.getSlider().setMinimum(minimum.intValue());
        this.numberEditor.getSlider().setMaximum(maximum.intValue());
        this.numberEditor.getSpinner().setSpinMinimum(minimum.doubleValue());
        this.numberEditor.getSpinner().setSpinMaximum(maximum.doubleValue());
    }

    public void setNumberFormat(String format) {
        this.numberEditor.getNumberField().setFormatString(format);
    }

    public void setDataTypeConverter(DataTypeConverter<Number, ?> dataTypeConverter) {
        this.dataTypeConverter = dataTypeConverter;
    }

    public Number getNumber() {
        return (Number)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setNumber((Number)bean);
    }

    public void setNumber(Number number) {
        this.numberEditor.setValue(number.doubleValue());
        super.setObject(number);
    }

    public void numberChanged() {
        if (this.dataTypeConverter == null) {
            this.setObject(this.numberEditor.getValue());
        } else {
            this.setObject(this.dataTypeConverter.convert(this.numberEditor.getValue()));
        }
    }
}

