/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.swing.decorator.Decorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class ArrowDecorator
implements Decorator {
    public static final int DEFAULT_BASE = 4;
    public static final int DEFAULT_HEIGHT = 2;
    private int baseScale;
    private int heightScale;
    private int direction;
    private int xAdjust;
    private int yAdjust;
    private Color arrowColor;
    private int arrowCount;

    public ArrowDecorator() {
        this(5);
    }

    public ArrowDecorator(int direction) {
        this(direction, Color.BLACK);
    }

    public ArrowDecorator(int direction, Color arrowColor) {
        this(direction, arrowColor, new Dimension(4, 2));
    }

    public ArrowDecorator(int direction, Color arrowColor, Dimension size) {
        this.setDirection(direction);
        this.setArrowColor(arrowColor);
        this.setArrowCount(1);
        this.setBaseScale(size.width);
        this.setHeightScale(size.height);
        this.setXAdjust(0);
        this.setYAdjust(0);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        this.arrowColor = color;
    }

    public int getArrowCount() {
        return this.arrowCount;
    }

    public void setArrowCount(int arrowCount) {
        this.arrowCount = arrowCount;
    }

    public int getBaseScale() {
        return this.baseScale;
    }

    public void setBaseScale(int baseScale) {
        this.baseScale = baseScale;
    }

    public int getHeightScale() {
        return this.heightScale;
    }

    public void setHeightScale(int heightScale) {
        this.heightScale = heightScale;
    }

    public int getXAdjust() {
        return this.xAdjust;
    }

    public void setXAdjust(int adjust) {
        this.xAdjust = adjust;
    }

    public int getYAdjust() {
        return this.yAdjust;
    }

    public void setYAdjust(int adjust) {
        this.yAdjust = adjust;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension componentSize = c.getSize();
        if (componentSize.width % 2 != 0) {
            --componentSize.width;
        }
        if (componentSize.height % 2 != 0) {
            --componentSize.height;
        }
        Point arrowCenter = new Point(componentSize.width / 2 + this.xAdjust, componentSize.height / 2 + this.yAdjust);
        int locationXAdjust = this.baseScale * 1;
        int locationYAdjust = this.heightScale * 1;
        switch (this.direction) {
            case 1: 
            case 5: {
                locationXAdjust = 0;
                arrowCenter.y -= (this.arrowCount - 1) * this.heightScale / 2;
                break;
            }
            case 3: 
            case 7: {
                locationYAdjust = 0;
                arrowCenter.x -= (this.arrowCount - 1) * this.baseScale / 2;
                break;
            }
            case 2: 
            case 6: {
                arrowCenter.y -= (this.arrowCount - 1) * this.heightScale / 2;
                arrowCenter.x += (this.arrowCount - 1) * this.baseScale / 2;
                break;
            }
            case 4: 
            case 8: {
                arrowCenter.y += (this.arrowCount - 1) * this.heightScale / 2;
                arrowCenter.x -= (this.arrowCount - 1) * this.baseScale / 2;
                locationYAdjust *= -1;
            }
        }
        g.setColor(this.arrowColor);
        Polygon triangle = new Polygon();
        int i = 0;
        while (i < this.arrowCount) {
            switch (this.direction) {
                case 5: {
                    this.getSouthTriangle(triangle, componentSize, arrowCenter);
                    break;
                }
                case 1: {
                    this.getNorthTriangle(triangle, componentSize, arrowCenter);
                    break;
                }
                case 3: {
                    this.getEastTriangle(triangle, componentSize, arrowCenter);
                    break;
                }
                case 7: {
                    this.getWestTriangle(triangle, componentSize, arrowCenter);
                    break;
                }
                case 4: {
                    this.getSouthEastTriangle(triangle, componentSize, arrowCenter);
                    break;
                }
                case 6: {
                    this.getSouthWestTriangle(triangle, componentSize, arrowCenter);
                    break;
                }
                case 2: {
                    this.getNorthEastTriangle(triangle, componentSize, arrowCenter);
                    break;
                }
                case 8: {
                    this.getNorthWestTriangle(triangle, componentSize, arrowCenter);
                }
            }
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.fillPolygon(triangle);
            triangle.reset();
            arrowCenter.x += locationXAdjust;
            arrowCenter.y += locationYAdjust;
            ++i;
        }
    }

    private void getSouthTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x - this.baseScale, arrowCenter.y - this.heightScale);
        triangle.addPoint(arrowCenter.x + this.baseScale, arrowCenter.y - this.heightScale);
        triangle.addPoint(arrowCenter.x, arrowCenter.y + this.heightScale);
    }

    private void getNorthTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x - this.baseScale, arrowCenter.y + this.heightScale);
        triangle.addPoint(arrowCenter.x + this.baseScale, arrowCenter.y + this.heightScale);
        triangle.addPoint(arrowCenter.x, arrowCenter.y - this.heightScale);
    }

    private void getWestTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x + this.heightScale, arrowCenter.y - this.baseScale);
        triangle.addPoint(arrowCenter.x + this.heightScale, arrowCenter.y + this.baseScale);
        triangle.addPoint(arrowCenter.x - this.heightScale, arrowCenter.y);
    }

    private void getEastTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x - this.heightScale, arrowCenter.y - this.baseScale);
        triangle.addPoint(arrowCenter.x - this.heightScale, arrowCenter.y + this.baseScale);
        triangle.addPoint(arrowCenter.x + this.heightScale, arrowCenter.y);
    }

    private void getSouthEastTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x - this.baseScale, arrowCenter.y + this.heightScale);
        triangle.addPoint(arrowCenter.x + this.heightScale, arrowCenter.y - this.baseScale);
        triangle.addPoint(arrowCenter.x + this.heightScale, arrowCenter.y + this.heightScale);
    }

    private void getSouthWestTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x - this.heightScale, arrowCenter.y - this.baseScale);
        triangle.addPoint(arrowCenter.x + this.baseScale, arrowCenter.y + this.heightScale);
        triangle.addPoint(arrowCenter.x - this.heightScale, arrowCenter.y + this.heightScale);
    }

    private void getNorthEastTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x - this.baseScale, arrowCenter.y - this.heightScale);
        triangle.addPoint(arrowCenter.x + this.heightScale, arrowCenter.y + this.baseScale);
        triangle.addPoint(arrowCenter.x + this.heightScale, arrowCenter.y - this.heightScale);
    }

    private void getNorthWestTriangle(Polygon triangle, Dimension componentSize, Point arrowCenter) {
        triangle.addPoint(arrowCenter.x + this.baseScale, arrowCenter.y - this.heightScale);
        triangle.addPoint(arrowCenter.x - this.heightScale, arrowCenter.y + this.baseScale);
        triangle.addPoint(arrowCenter.x - this.heightScale, arrowCenter.y - this.heightScale);
    }
}

