/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.graphics.drawing.CogWheelDrawer;
import com.jmorgan.lang.MathExt;
import com.jmorgan.swing.decorator.Decorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class CogWheelDecorator
implements Decorator {
    private Color edgeColor;
    private Color fillColor;
    private double radius;

    public CogWheelDecorator(Color edgeColor, Color fillColor, double radius) {
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Override
    public void paint(Graphics graphics, JComponent component) {
        Dimension componentSize = component.getSize();
        int radiusX = (componentSize.width - 8) / 2;
        int radiusY = (componentSize.height - 8) / 2;
        int radius = Math.min(radiusX, radiusY);
        Point2D center2D = MathExt.getCenter(componentSize);
        Point center = new Point((int)center2D.getX(), (int)center2D.getY());
        CogWheelDrawer cogWheelDrawer = new CogWheelDrawer(center, radius, this.edgeColor, this.fillColor);
        cogWheelDrawer.draw(graphics);
    }
}

