/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.swing.decorator.Decorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import javax.swing.JComponent;

public class FileOpenDecorator
implements Decorator {
    private Color lineColor;
    private Color discColor;
    private Color metalColor;
    private Color arrowColor;

    public FileOpenDecorator() {
        this.setLineColor(Color.GRAY);
        this.setDiscColor(Color.LIGHT_GRAY);
        this.setMetalColor(new Color(224, 224, 224));
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public void setArrowColor(Color arrowColor) {
        this.arrowColor = arrowColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getDiscColor() {
        return this.discColor;
    }

    public void setDiscColor(Color discColor) {
        this.discColor = discColor;
    }

    public Color getMetalColor() {
        return this.metalColor;
    }

    public void setMetalColor(Color metalColor) {
        this.metalColor = metalColor;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension componentSize = c.getSize();
        if (componentSize.width % 2 != 0) {
            --componentSize.width;
        }
        if (componentSize.height % 2 != 0) {
            --componentSize.height;
        }
        Point center = new Point(componentSize.width / 2, componentSize.height / 2);
        int minSize = Math.min(componentSize.width, componentSize.height);
        int inset = (int)((double)minSize * 0.26);
        int size = Math.min(componentSize.width, componentSize.height) - inset;
        int smallInset = (int)((double)size * 0.16);
        int largeInset = (int)((double)size * 0.22);
        int halfSize = (int)((double)size / 2.0);
        int thirdSize = (int)((double)size / 3.0);
        g.setColor(this.discColor);
        g.fillRect(center.x - halfSize, center.y - halfSize, size, size);
        g.setColor(this.metalColor);
        g.fillRect(center.x - halfSize + smallInset, center.y - halfSize, size - smallInset * 2, halfSize);
        g.fillRect(center.x - halfSize + largeInset, center.y + halfSize - thirdSize, size - largeInset * 2, thirdSize);
        g.setColor(this.lineColor);
        g.drawRect(center.x - halfSize, center.y - halfSize, size, size);
        g.drawRect(center.x - halfSize + smallInset, center.y - halfSize, size - smallInset * 2, halfSize);
        g.drawRect(center.x - halfSize + largeInset, center.y + halfSize - thirdSize, size - largeInset * 2, thirdSize);
        Polygon arrow = new Polygon();
        arrow.addPoint(center.x - 4, center.y - 4);
        arrow.addPoint(center.x + halfSize / 2, center.y - halfSize + 4);
        arrow.addPoint(center.x + halfSize / 2 - 4, center.y - halfSize);
        arrow.addPoint(center.x + halfSize + 4, center.y - halfSize - 4);
        arrow.addPoint(center.x + halfSize, center.y - halfSize / 2);
        arrow.addPoint(center.x + halfSize - 4, center.y - halfSize / 2 - 4);
        arrow.addPoint(center.x + 4, center.y + 4);
        g.setColor(this.arrowColor);
        g.fillPolygon(arrow);
        g.setColor(this.lineColor);
        g.drawPolygon(arrow);
    }
}

