/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.decorator.Decorator;
import com.jmorgan.swing.util.ContainerService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public class OverlayDecorator
implements Decorator {
    private Color overlayColor;
    private Color overlayBackground;
    private String overlayText;
    private Icon overlayIcon;
    private JMLabel overlayLabel = new JMLabel();

    public OverlayDecorator() {
        this(null, null, null, null);
    }

    public OverlayDecorator(Color overlayColor) {
        this(overlayColor, null, null, null);
    }

    public OverlayDecorator(Color overlayColor, String overlayText) {
        this(overlayColor, null, overlayText, null);
    }

    public OverlayDecorator(Color overlayColor, Icon overlayIcon) {
        this(overlayColor, null, null, overlayIcon);
    }

    public OverlayDecorator(Color overlayColor, Color overlayBackground, String overlayText, Icon overlayIcon) {
        this.setOverlayColor(overlayColor);
        this.setOverlayBackground(overlayBackground);
        this.setOverlayText(overlayText);
        this.setOverlayIcon(overlayIcon);
    }

    public Color getOverlayColor() {
        return this.overlayColor;
    }

    public void setOverlayColor(Color overlayColor) {
        this.overlayColor = overlayColor;
        this.overlayLabel.setForeground(overlayColor);
    }

    public Color getOverlayBackground() {
        return this.overlayBackground;
    }

    public void setOverlayBackground(Color overlayColor) {
        if (overlayColor != null) {
            this.overlayLabel.setOpaque(true);
            this.overlayLabel.setBackground(overlayColor);
        } else {
            this.overlayLabel.setOpaque(false);
        }
    }

    public String getOverlayText() {
        return this.overlayText;
    }

    public void setOverlayText(String overlayText) {
        this.overlayText = overlayText;
        if (overlayText != null) {
            this.overlayLabel.setText(overlayText);
            this.overlayLabel.setHorizontalAlignment(0);
        } else {
            this.overlayLabel.setText("");
        }
    }

    public Icon getOverlayIcon() {
        return this.overlayIcon;
    }

    public void setOverlayIcon(Icon overlayIcon) {
        this.overlayIcon = overlayIcon;
        if (overlayIcon != null) {
            this.overlayLabel.setIcon(overlayIcon);
            this.overlayLabel.setIconTextGap(20);
        } else {
            this.overlayLabel.setIcon(null);
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent component) {
        ContainerService.setEnabled(component, false);
        Dimension size = component.getSize();
        this.overlayLabel.setSize(size);
        this.overlayLabel.paint(graphics);
    }
}

