/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.event;

import com.jmorgan.beans.util.AbstractMaskedEventInvoker;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;

public class KeyEventInvoker
extends AbstractMaskedEventInvoker<KeyEvent>
implements KeyListener {
    public static final int KEY_TYPED = 1;
    public static final int KEY_PRESSED = 2;
    public static final int KEY_RELEASED = 4;
    private ArrayList<Integer> keyCodeFilter;

    public KeyEventInvoker(Object eventProducer, int eventMask, Object target, String methodName) {
        super(eventProducer, eventMask, target, methodName);
        this.setListenerAddRemoveMethodNames("addKeyListener", "removeKeyListener");
    }

    public KeyEventInvoker(Object eventProducer, int eventMask, Object target, String methodName, Object ... arguments) {
        super(eventProducer, eventMask, target, methodName, arguments);
        this.setListenerAddRemoveMethodNames("addKeyListener", "removeKeyListener");
    }

    public void addKeyFilter(int keyCode) {
        if (this.keyCodeFilter == null) {
            this.keyCodeFilter = new ArrayList();
        }
        this.keyCodeFilter.add(new Integer(keyCode));
    }

    public void setKeyFilter(int[] keyCodes) {
        if (this.keyCodeFilter != null) {
            this.keyCodeFilter.clear();
            this.keyCodeFilter = null;
        }
        if (keyCodes == null || keyCodes.length == 0) {
            return;
        }
        this.keyCodeFilter = new ArrayList();
        int[] nArray = keyCodes;
        int n = keyCodes.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            this.keyCodeFilter.add(new Integer(k));
            ++n2;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.invokeFor(keyEvent, 2);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.invokeFor(keyEvent, 4);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.invokeFor(keyEvent, 1);
    }

    private void invokeFor(KeyEvent keyEvent, int mask) {
        if (this.keyCodeFilter != null) {
            int keyCode = keyEvent.getKeyCode();
            boolean match = false;
            for (int kc : this.keyCodeFilter) {
                if (kc != keyCode) continue;
                match = true;
                break;
            }
            if (!match) {
                return;
            }
        }
        this.setEvent(keyEvent);
        this.invokeForEvent(mask);
    }
}

