/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class CellLayoutConstraints {
    public static final int DEFAULT_HORZ_CELLS = 1;
    public static final int DEFAULT_VERT_CELLS = 1;
    int cellRow = 0;
    int cellColumn = 0;
    int horzCells = 1;
    int vertCells = 1;

    public CellLayoutConstraints() {
    }

    public CellLayoutConstraints(int row, int col) {
        this.cellRow = row;
        this.cellColumn = col;
    }

    public CellLayoutConstraints(int row, int col, int w, int h) {
        this(row, col);
        this.horzCells = w;
        this.vertCells = h;
    }

    public CellLayoutConstraints(Point p) {
        this(p.y, p.x);
    }

    public CellLayoutConstraints(Point p, int w, int h) {
        this(p.y, p.x, w, h);
    }

    public CellLayoutConstraints(int row, int col, Dimension d) {
        this(row, col, d.width, d.height);
    }

    public CellLayoutConstraints(Point p, Dimension d) {
        this(p.y, p.x, d.width, d.height);
    }

    public CellLayoutConstraints(Rectangle r) {
        this(r.y, r.x, r.width, r.height);
    }

    public CellLayoutConstraints(CellLayoutConstraints c) {
        this(c.cellRow, c.cellColumn, c.horzCells, c.vertCells);
    }

    public int getRow() {
        return this.cellRow;
    }

    public int getColumn() {
        return this.cellColumn;
    }

    public int getWidth() {
        return this.horzCells;
    }

    public int getHeight() {
        return this.vertCells;
    }

    public int getMaxHorizontalCell() {
        return this.cellColumn + this.horzCells;
    }

    public int getMaxVerticalCell() {
        return this.cellRow + this.vertCells;
    }
}

