/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import com.jmorgan.swing.layout.AbstractLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class CenterLayout
extends AbstractLayout {
    public static final int COMPONENT_PREFERRED_SIZE = 0;
    public static final int COMPONENT_SIZE = 1;
    public static final int CONTAINER_PREFERRED_SIZE = 2;
    public static final int CONTAINER_SIZE = 3;
    private Component component;
    private int layoutAlgorithm;

    public CenterLayout() {
        this(0);
    }

    public CenterLayout(int layoutAlgorithm) {
        this.setLayoutAlgorithm(layoutAlgorithm);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public int getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    public void setLayoutAlgorithm(int layoutAlgorithm) {
        if (layoutAlgorithm < 0 || layoutAlgorithm > 3) {
            throw new IllegalArgumentException("CenterLayout.setLayoutAlgorithm(int layoutAlgorithm): Layout Algorithm of " + layoutAlgorithm + " is out of range from 0 to 3");
        }
        this.layoutAlgorithm = layoutAlgorithm;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.getSize(target, 2);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getSize(parent, 0);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getSize(parent, 1);
    }

    private Dimension getSize(Container parent, int sizeType) {
        return this.layoutAlgorithm == 2 ? parent.getPreferredSize() : parent.getSize();
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] comp = parent.getComponents();
        Insets insets = parent.getInsets();
        Dimension parentSize = new Dimension(this.getSize(parent, -1));
        int parentHalfWidth = parentSize.width / 2;
        int parentHalfHeight = parentSize.height / 2;
        int i = 0;
        while (i < comp.length) {
            if (comp[i] != null && comp[i].isVisible()) {
                Dimension compSize = null;
                switch (this.layoutAlgorithm) {
                    case 0: {
                        compSize = comp[i].getPreferredSize();
                        break;
                    }
                    case 1: {
                        compSize = comp[i].getSize();
                        break;
                    }
                    case 2: 
                    case 3: {
                        compSize = new Dimension(parentSize);
                        compSize.width -= insets.left + insets.right;
                        compSize.height -= insets.top + insets.bottom;
                    }
                }
                int compHalfWidth = compSize.width / 2;
                int compHalfHeight = compSize.height / 2;
                int x = parentHalfWidth - compHalfWidth;
                int y = parentHalfHeight - compHalfHeight;
                comp[i].setBounds(x, y, compSize.width, compSize.height);
            }
            ++i;
        }
    }
}

