/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ColumnLayout
implements LayoutManager {
    private int gap;
    private int[] widths;

    public ColumnLayout() {
        this(1, null);
    }

    public ColumnLayout(int gap) {
        this(gap, null);
    }

    public ColumnLayout(int gap, int ... widths) {
        this.setGap(gap);
        this.setWidths(widths);
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public void addColumn(int width) {
        int[] newWidths = new int[this.widths.length + 1];
        System.arraycopy(this.widths, 0, newWidths, 0, this.widths.length);
        newWidths[this.widths.length] = width;
        this.widths = newWidths;
    }

    public void insertColumn(int width, int position) {
        int[] newWidths = new int[this.widths.length + 1];
        if (position == 0) {
            newWidths[0] = width;
            System.arraycopy(this.widths, 0, newWidths, 1, this.widths.length);
        } else {
            int i = 0;
            while (i < position) {
                newWidths[i] = this.widths[i];
                ++i;
            }
            newWidths[i++] = width;
            int j = position;
            while (j < this.widths.length) {
                newWidths[i] = this.widths[j];
                ++j;
                ++i;
            }
        }
        this.widths = newWidths;
    }

    public int[] getWidths() {
        return this.widths;
    }

    public void setWidths(int[] widths) {
        if (widths == null || widths.length == 0) {
            this.widths = new int[0];
            return;
        }
        if (this.widths == null || widths.length < this.widths.length) {
            this.widths = new int[widths.length];
        }
        int i = 0;
        while (i < this.widths.length) {
            if (i < widths.length) {
                this.widths[i] = widths[i];
            }
            ++i;
        }
        if (widths.length > this.widths.length) {
            i = this.widths.length;
            while (i < widths.length) {
                this.addColumn(widths[i]);
                ++i;
            }
        }
    }

    public void setWidth(int column, int width) {
        if (column < this.widths.length) {
            this.widths[column] = width;
        } else {
            int i = this.widths.length;
            while (i <= column) {
                if (i == column) {
                    this.addColumn(width);
                } else {
                    this.addColumn(0);
                }
                ++i;
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        this.defineWidths(parent);
        Component[] comp = parent.getComponents();
        Insets insets = parent.getInsets();
        int x = insets.left;
        int maxHeight = ColumnLayout.getMaxCompHeight(comp, 0);
        int i = 0;
        while (i < this.widths.length && i < comp.length) {
            comp[i].setBounds(x, insets.top, this.widths[i], maxHeight);
            x += this.widths[i] + this.gap;
            ++i;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 1);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    private Dimension getLayoutSize(Container parent, int type) {
        this.defineWidths(parent);
        int totalWidth = 0;
        int totalHeight = 0;
        int i = 0;
        while (i < this.widths.length) {
            totalWidth += this.widths[i];
            ++i;
        }
        totalWidth += (this.widths.length - 2) * this.gap;
        Component[] components = parent.getComponents();
        totalHeight = ColumnLayout.getMaxCompHeight(components, type);
        Insets insets = parent.getInsets();
        return new Dimension(totalWidth += insets.left + insets.right, totalHeight += insets.top + insets.bottom);
    }

    private void defineWidths(Container parent) {
        Component[] comps = parent.getComponents();
        int i = 0;
        while (i < this.widths.length && i < comps.length) {
            if (this.widths[i] <= 0) {
                this.widths[i] = comps[i].getPreferredSize().width;
            }
            ++i;
        }
        if (comps.length > this.widths.length) {
            i = this.widths.length;
            while (i < comps.length) {
                this.addColumn(comps[i].getPreferredSize().width);
                ++i;
            }
        }
    }

    private static int getMaxCompHeight(Component[] components, int type) {
        int totalHeight = 0;
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            int cHeight;
            Component c = componentArray[n2];
            int n3 = cHeight = type == 1 ? c.getHeight() : c.getPreferredSize().height;
            if (cHeight > totalHeight) {
                totalHeight = cHeight;
            }
            ++n2;
        }
        return totalHeight;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

