/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import com.jmorgan.swing.layout.AbstractLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;

public class EastWestLayout
extends AbstractLayout {
    public static final String EAST = "east";
    public static final String WEST = "west";
    public static final String CENTER = "center";
    private int hGap;
    private HashMap<Component, String> constraints = new HashMap();

    public EastWestLayout() {
        this(0);
    }

    public EastWestLayout(int horizontalGap) {
        this.hGap = horizontalGap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    private Dimension getLayoutSize(Container parent, int sizeType) {
        Dimension layoutSize = new Dimension(0, 0);
        Component[] components = parent.getComponents();
        int westWidth = 0;
        int eastWidth = 0;
        int centerWidth = 0;
        int i = 0;
        while (i < components.length) {
            String constraint = this.constraints.get(components[i]);
            Dimension size = null;
            switch (sizeType) {
                case 2: {
                    size = components[i].getMaximumSize();
                    break;
                }
                case 1: {
                    size = components[i].getMinimumSize();
                    break;
                }
                case 0: {
                    size = components[i].getPreferredSize();
                }
            }
            if (size.height > layoutSize.height) {
                layoutSize.height = size.height;
            }
            if (constraint.equals(WEST)) {
                westWidth = size.width;
            }
            if (constraint.equals(CENTER)) {
                centerWidth = size.width;
            }
            if (constraint.equals(EAST)) {
                eastWidth = size.width;
            }
            ++i;
        }
        layoutSize.width = centerWidth + Math.max(eastWidth, westWidth) * 2;
        Insets i2 = parent.getInsets();
        layoutSize.width += i2.left + i2.right + (components.length - 1) * this.hGap;
        layoutSize.height += i2.top + i2.bottom;
        return layoutSize;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 2);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 1);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension parentSize = parent.getSize();
        Insets parentInsets = parent.getInsets();
        Component[] components = parent.getComponents();
        Component eastComponent = null;
        Component centerComponent = null;
        Component westComponent = null;
        Insets borderInsets = this.getBorderInsets(parent);
        int i = 0;
        while (i < components.length) {
            String constraint = this.constraints.get(components[i]);
            if (constraint.equals(WEST)) {
                westComponent = components[i];
            }
            if (constraint.equals(CENTER)) {
                centerComponent = components[i];
            }
            if (constraint.equals(EAST)) {
                eastComponent = components[i];
            }
            ++i;
        }
        int totalHGap = (components.length - 1) * this.hGap;
        int centerWidth = centerComponent != null ? centerComponent.getPreferredSize().width : 0;
        int height = parentSize.height - parentInsets.top - parentInsets.bottom - borderInsets.top + borderInsets.bottom;
        int remainingWidth = parentSize.width - parentInsets.left - parentInsets.right - borderInsets.left - borderInsets.right - centerWidth - totalHGap;
        int eastWestWidth = eastComponent != null && westComponent != null ? remainingWidth / 2 : (eastComponent == null || westComponent == null ? remainingWidth : 0);
        int x = parentInsets.left + borderInsets.left;
        int y = parentInsets.top + borderInsets.top;
        if (westComponent != null) {
            westComponent.setBounds(x, y, eastWestWidth, height);
            x += eastWestWidth + this.hGap;
        }
        if (centerComponent != null) {
            centerComponent.setBounds(x, y, centerWidth, height);
            x += centerWidth + this.hGap;
        }
        if (eastComponent != null) {
            eastComponent.setBounds(x, y, eastWestWidth, height);
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            constraints = CENTER;
        }
        if (!(constraints instanceof String)) {
            throw new IllegalArgumentException("Constraints of EastWestLayout must be a String");
        }
        this.constraints.put(comp, (String)constraints);
    }
}

