/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import com.jmorgan.util.Pair;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class OutlineLayout
implements LayoutManager2 {
    public static final int DEFAULT_INDENT = 20;
    public static final int DEFAULT_VSPACE = 1;
    private int indentionSize = 20;
    private int vSpace = 1;
    private Vector<Pair<Component, Component>> constraints = new Vector();
    private int layoutY;
    private Insets totalInsets;

    public OutlineLayout() {
    }

    public OutlineLayout(int indentionSize, int vSpace) {
        this();
        this.indentionSize = indentionSize;
        this.vSpace = vSpace;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        System.out.println("addLayoutComponent(String, Component) called");
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) throws IllegalArgumentException, UnsupportedOperationException {
        if (constraints == null) {
            constraints = comp.getParent();
        }
        if (!(constraints instanceof Component)) {
            throw new IllegalArgumentException("Constraints must be an instance of java.awt.Component");
        }
        Component c = (Component)constraints;
        this.setConstraints(comp, c);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public int getVerticalSpacing() {
        return this.vSpace;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layoutY = parent instanceof Frame || parent instanceof Dialog ? 30 : 1;
        this.totalInsets = OutlineLayout.getInsets(parent);
        this.layoutY += this.totalInsets.top;
        this.layoutNode(parent, 0);
    }

    private void layoutNode(Component node, int level) {
        for (Pair<Component, Component> p : this.constraints) {
            if (p.second != node) continue;
            int x = level * this.indentionSize + this.totalInsets.left;
            int y = this.layoutY;
            Component c = (Component)p.first;
            int w = c.getPreferredSize().width;
            int h = c.getPreferredSize().height;
            c.setBounds(x, y, w, h);
            this.layoutY += h + this.vSpace;
            this.layoutNode(c, level + 1);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.getLayoutSize(target, 2);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension maxD = this.maximumLayoutSize(parent);
        Dimension prefD = this.preferredLayoutSize(parent);
        Dimension min = new Dimension();
        min.width = Math.min(maxD.width, prefD.width);
        min.height = Math.min(maxD.height, prefD.height);
        return min;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    private Dimension getLayoutSize(Container parent, int type) {
        int height = this.constraints.size() * this.vSpace - this.vSpace;
        int width = 0;
        if (parent instanceof Frame || parent instanceof Dialog) {
            height += 30;
        }
        Insets insets = OutlineLayout.getInsets(parent);
        height += insets.top + insets.bottom;
        int widthInsets = insets.left + insets.right;
        for (Pair<Component, Component> p : this.constraints) {
            int w = 0;
            if (type == 0) {
                height += ((Component)p.first).getPreferredSize().height;
                w = this.getLevel(p, parent) * this.indentionSize + ((Component)p.first).getPreferredSize().width;
            } else {
                height += ((Component)p.first).getHeight();
                w = this.getLevel(p, parent) * this.indentionSize + ((Component)p.first).getWidth();
            }
            if ((w += widthInsets) <= width) continue;
            width = w;
        }
        return new Dimension(width + 1, height + 1);
    }

    private static Insets getInsets(Container parent) {
        Insets bInsets;
        JComponent c;
        Border border;
        Insets insets = (Insets)parent.getInsets().clone();
        if (parent instanceof JComponent && (border = (c = (JComponent)parent).getBorder()) != null && (bInsets = border.getBorderInsets(parent)) != null) {
            insets.left += bInsets.left;
            insets.bottom += bInsets.bottom;
            insets.right += bInsets.right;
            insets.top += bInsets.top;
        }
        return insets;
    }

    private int getLevel(Pair<Component, Component> constraint, Container parent) {
        int level = 0;
        while (constraint.second != parent) {
            for (Pair<Component, Component> p : this.constraints) {
                if (p.first != constraint.second) continue;
                constraint = p;
                break;
            }
            ++level;
        }
        return level;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        for (Pair<Component, Component> p : this.constraints) {
            if (p.first != comp) continue;
            this.constraints.remove(p);
            break;
        }
    }

    protected void setConstraints(Component c, Component parent) {
        this.constraints.add(new Pair<Component, Component>(c, parent));
    }

    public void setVerticalSpacing(int vSpace) {
        this.vSpace = vSpace;
    }
}

