/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import com.jmorgan.swing.layout.XYLayoutConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;

public class XYLayout
implements LayoutManager2 {
    private HashMap<Component, XYLayoutConstraints> constraints = new HashMap();

    @Override
    public void addLayoutComponent(Component comp, Object constraints) throws IllegalArgumentException, UnsupportedOperationException {
        if (constraints == null) {
            if (this.constraints.containsKey(comp)) {
                return;
            }
            throw new UnsupportedOperationException("To use java.awt.Container.add(Component), call XYLayout.setConstraints() first, otherwise, use java.awt.Container.add(Component comp, Object constraints)");
        }
        if (!(constraints instanceof XYLayoutConstraints)) {
            throw new IllegalArgumentException("Constraints must be an instance of XYLayoutConstraints");
        }
        XYLayoutConstraints c = (XYLayoutConstraints)constraints;
        this.setConstraints(comp, c);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("The method, XYLayout.addLayoutComponent(String name, Component comp) is not supported.");
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container arg0) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets inset = parent.getInsets();
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            XYLayoutConstraints loc = this.constraints.get(comp);
            int x = inset.left + loc.getX();
            int y = inset.top + loc.getY();
            int w = loc.getWidth();
            int h = loc.getHeight();
            Dimension preferredSize = comp.getPreferredSize();
            if (w < 0) {
                w = preferredSize.width;
            }
            if (h < 0) {
                h = preferredSize.height;
            }
            comp.setBounds(x, y, w, h);
            ++n2;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension result = new Dimension();
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            XYLayoutConstraints constraint = this.constraints.get(comp);
            Dimension preferredSize = comp.getPreferredSize();
            int compWidth = constraint.getWidth();
            if (compWidth < 0) {
                compWidth = preferredSize.width;
            }
            int width = constraint.getX() + compWidth;
            int compHeight = constraint.getHeight();
            if (compHeight < 0) {
                compHeight = preferredSize.height;
            }
            int height = constraint.getY() + compHeight;
            if (width > result.width) {
                result.width = width;
            }
            if (height > result.height) {
                result.height = height;
            }
            ++n2;
        }
        Insets insets = parent.getInsets();
        result.width += insets.left + insets.right;
        result.height += insets.top + insets.bottom;
        return result;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    public HashMap<Component, XYLayoutConstraints> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(HashMap<Component, XYLayoutConstraints> constraints) {
        this.constraints = constraints;
    }

    public void setConstraints(Component c, XYLayoutConstraints loc) {
        XYLayoutConstraints copy = this.constraints.containsValue(loc) ? new XYLayoutConstraints(loc.getX(), loc.getY(), loc.getWidth(), loc.getHeight()) : loc;
        this.constraints.put(c, copy);
    }
}

