/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import java.util.ArrayList;
import java.util.BitSet;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListToggleSelectionModel
implements ListSelectionModel {
    private static final boolean SET = true;
    private static final boolean REMOVE = false;
    private static final boolean SELECTED = true;
    private BitSet selection = new BitSet(32);
    private BitSet selectionClone;
    private int anchorIndex = -1;
    private int leadIndex = -1;
    private boolean isAdjusting = false;
    private boolean debugging = false;
    protected ArrayList<ListSelectionListener> listeners = new ArrayList();

    @Override
    public void setSelectionInterval(int index0, int index1) {
        this.changeSelectionInterval(index0, index1, true);
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        this.setSelectionInterval(index0, index1);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        this.changeSelectionInterval(index0, index1, false);
    }

    private void changeSelectionInterval(int index0, int index1, boolean changeBehavior) {
        if (this.debugging) {
            System.out.println("changeSelectionInterval(" + index0 + ", " + index1 + ", " + (changeBehavior ? "set" : "remove") + ")");
        }
        if (index0 < 0 || index1 < 0) {
            return;
        }
        this.anchorIndex = index0;
        this.leadIndex = index1;
        if (this.debugging) {
            System.out.println("Before: " + String.valueOf(this.selection));
        }
        this.cloneSelection();
        int firstIndex = Math.min(index0, index1);
        int lastIndex = Math.max(index0, index1);
        int i = firstIndex;
        while (i <= lastIndex) {
            if (changeBehavior) {
                if (this.selection.get(i)) {
                    this.selection.clear(i);
                } else {
                    this.selection.set(i);
                }
            } else if (this.selection.get(i)) {
                this.selection.set(i);
            } else {
                this.selection.clear(i);
            }
            if (this.debugging) {
                System.out.println("After: " + String.valueOf(this.selection));
            }
            ++i;
        }
        this.fireValueChanged(this.isAdjusting);
    }

    @Override
    public int getMinSelectionIndex() {
        int i = 0;
        while (i < this.selection.length()) {
            if (this.selection.get(i)) {
                if (this.debugging) {
                    System.out.println("getMinSelectionIndex <-- " + i);
                }
                return i;
            }
            ++i;
        }
        if (this.debugging) {
            System.out.println("getMinSelectionIndex <-- -1");
        }
        return -1;
    }

    @Override
    public int getMaxSelectionIndex() {
        int i = this.selection.length() - 1;
        while (i >= 0) {
            if (this.selection.get(i)) {
                if (this.debugging) {
                    System.out.println("getMaxSelectionIndex <-- " + i);
                }
                return i;
            }
            --i;
        }
        if (this.debugging) {
            System.out.println("getMaxSelectionIndex <-- -1");
        }
        return -1;
    }

    @Override
    public boolean isSelectedIndex(int index) {
        if (this.debugging) {
            System.out.println("isSelectedIndex(" + index + ") <-- " + this.selection.get(index));
        }
        if (index < 0 || index > this.selection.size()) {
            return false;
        }
        return this.selection.get(index);
    }

    @Override
    public int getAnchorSelectionIndex() {
        if (this.debugging) {
            System.out.println("getAnchorSelectionIndex <-- " + this.anchorIndex);
        }
        return this.anchorIndex;
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        if (this.debugging) {
            System.out.println("setAnchorSelectionIndex(" + index + ")");
        }
        this.anchorIndex = index;
    }

    @Override
    public int getLeadSelectionIndex() {
        if (this.debugging) {
            System.out.println("getLeadSelectionIndex <-- " + this.leadIndex);
        }
        return this.leadIndex;
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        if (this.debugging) {
            System.out.println("setLeadSelectionIndex(" + index + ")");
        }
        this.leadIndex = index;
    }

    @Override
    public void clearSelection() {
        if (this.debugging) {
            System.out.println("clearSelection");
        }
        if (this.isSelectionEmpty()) {
            return;
        }
        this.cloneSelection();
        int selectionLength = this.selection.length();
        this.selection = new BitSet(selectionLength);
        this.leadIndex = -1;
        this.anchorIndex = -1;
        this.fireValueChanged(false);
    }

    @Override
    public boolean isSelectionEmpty() {
        int i = 0;
        int j = this.selection.length();
        while (i < j) {
            if (this.selection.get(i)) {
                if (this.debugging) {
                    System.out.println("isSelectionEmpty <-- false");
                }
                return false;
            }
            ++i;
        }
        if (this.debugging) {
            System.out.println("isSelectionEmpty <-- true");
        }
        return true;
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        if (this.debugging) {
            System.out.println("insertIndexInterval(" + index + ", " + length + ", " + (before ? "before" : "after)"));
        }
        int insertLocation = before ? index : index + 1;
        int oldLength = this.selection.length();
        int newLength = oldLength + length;
        while (oldLength < newLength) {
            if (this.selection.get(insertLocation)) {
                this.selection.set(oldLength);
            }
            this.selection.clear(insertLocation);
            ++insertLocation;
            ++oldLength;
        }
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        if (this.debugging) {
            System.out.println("removeIndexInterval(" + index0 + ", " + index1 + ")");
        }
        int minIndex = Math.min(index0, index1);
        int maxIndex = Math.min(index0, index1);
        int oldLength = this.selection.length();
        BitSet newSelection = new BitSet(oldLength - (maxIndex - minIndex + 1));
        int i = 0;
        while (i < minIndex) {
            if (this.selection.get(i)) {
                newSelection.set(i);
            }
            ++i;
        }
        i = maxIndex + 1;
        int j = minIndex;
        while (i < oldLength) {
            if (this.selection.get(i)) {
                newSelection.set(j);
            }
            ++i;
            ++j;
        }
        this.selection = newSelection;
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        if (this.debugging) {
            System.out.println("setValueIsAdjusting(" + valueIsAdjusting + ")");
        }
        if (valueIsAdjusting != this.isAdjusting) {
            this.isAdjusting = valueIsAdjusting;
            this.fireValueChanged(true);
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        if (this.debugging) {
            System.out.println("getValueIsAdjusting <-- " + this.isAdjusting);
        }
        return this.isAdjusting;
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        if (this.debugging) {
            System.out.println("setSelectionMode(" + selectionMode + ")");
        }
    }

    @Override
    public int getSelectionMode() {
        if (this.debugging) {
            System.out.println("getSelectionMode <-- MULTIPLE_INTERVAL_SELECTION");
        }
        return 2;
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        if (this.debugging) {
            System.out.println("addListSelectionListener(" + String.valueOf(listener) + ")");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        if (this.debugging) {
            System.out.println("removeListSelectionListener(" + String.valueOf(listener) + ")");
        }
        this.listeners.remove(listener);
    }

    private void cloneSelection() {
        this.selectionClone = (BitSet)this.selection.clone();
    }

    private void fireValueChanged(boolean hasAdjusted) {
        if (hasAdjusted || !this.selection.equals(this.selectionClone)) {
            if (this.debugging) {
                System.out.println("Notifying Listeners");
            }
            ListSelectionEvent event = new ListSelectionEvent(this, this.anchorIndex, this.leadIndex, this.isAdjusting);
            for (ListSelectionListener listener : this.listeners) {
                listener.valueChanged(event);
            }
        }
    }
}

