/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.swing.menu.MenuService;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;

public class MenuBarService {
    JMenuBar client;

    public MenuBarService(JMenuBar mb) {
        this.setMenuBar(mb);
    }

    public JMenuBar getMenuBar() {
        return this.client;
    }

    public void setMenuBar(JMenuBar mb) {
        this.client = mb;
    }

    protected Container getTopMenuContainer() {
        Container container = this.client.getParent();
        while (!(container instanceof JFrame || container instanceof JInternalFrame || container instanceof JApplet)) {
            container = container.getParent();
        }
        return container;
    }

    public JMenu findItem(String label) {
        MenuElement[] elements = this.client.getSubElements();
        int i = 0;
        while (i < elements.length) {
            JMenu mi = (JMenu)elements[i];
            if (mi.getText().equalsIgnoreCase(label)) {
                return mi;
            }
            ++i;
        }
        return null;
    }

    public Collection<MenuElement> getMenus() {
        ArrayList<MenuElement> menus = new ArrayList<MenuElement>();
        int count = this.client.getMenuCount();
        int i = 0;
        while (i < count) {
            menus.add(this.client.getMenu(i));
            ++i;
        }
        return menus;
    }

    public Collection<JMenuItem> getMenuItems() {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        Collection<MenuElement> menus = this.getMenus();
        for (MenuElement element : menus) {
            JMenu menu = (JMenu)element;
            MenuService ms = new MenuService(menu);
            menuItems.addAll(ms.getMenuItems());
        }
        return menuItems;
    }
}

