/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.menu.JMMenu;
import com.jmorgan.util.collection.MethodExecutor;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class MenuGroup
extends JMBean {
    private ArrayList<JComponent> menuComponents = new ArrayList();
    private MethodExecutor<JComponent> methodExector = new MethodExecutor<JComponent>(this.menuComponents, "");

    public MenuGroup() {
        this.methodExector.setSynchronousExecution(true);
    }

    public Collection<JComponent> getMenuComponents() {
        return this.menuComponents;
    }

    public void addMenu(JMenu menu) {
        this.menuComponents.add(menu);
    }

    public void addMenuItem(JMenuItem menuItem) {
        this.menuComponents.add(menuItem);
    }

    public void addSeparator() {
        this.addSeparator(new JSeparator());
    }

    public void addSeparator(JSeparator separator) {
        this.menuComponents.add(separator);
    }

    public void setEnabled(boolean state) {
        this.methodExector.setMethodName("setEnabled");
        this.methodExector.setMethodParameters(new Boolean[]{state});
        this.methodExector.execute();
    }

    public void setEnabled(String itemTextRegex, boolean state) {
        for (JComponent component : this.menuComponents) {
            String text;
            if (!BeanService.hasProperty(component, "text") || !(text = (String)BeanService.getPropertyValue(component, "text")).matches(itemTextRegex)) continue;
            component.setEnabled(state);
        }
    }

    public void setVisible(boolean state) {
        this.methodExector.setMethodName("setVisible");
        this.methodExector.setMethodParameters(new Boolean[]{state});
        this.methodExector.execute();
    }

    public void setVisible(String itemTextRegex, boolean state) {
        for (JComponent component : this.menuComponents) {
            String text;
            if (!BeanService.hasProperty(component, "text") || !(text = (String)BeanService.getPropertyValue(component, "text")).matches(itemTextRegex)) continue;
            component.setVisible(state);
        }
    }

    public JMMenu getMenu(String menuText) {
        for (JComponent menuItem : this.menuComponents) {
            JMMenu menu;
            String label;
            if (!(menuItem instanceof JMMenu) || !(label = (menu = (JMMenu)menuItem).getText()).equals(menuText)) continue;
            return menu;
        }
        return null;
    }
}

