/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

public class MenuService {
    public static final int MENUITEM_LABEL = 0;
    public static final int MENUITEM_ACTION_COMMAND = 1;
    JMenu client;

    public MenuService(JMenu menu) {
        this.setMenu(menu);
    }

    public JMenu getMenu() {
        return this.client;
    }

    public void setMenu(JMenu menu) {
        this.client = menu;
    }

    public JMenuItem findItem(String menuID) {
        return this.findItem(menuID, 0);
    }

    public JMenuItem findItem(String menuID, int type) {
        ArrayList itemList = (ArrayList)this.getMenuItems();
        for (JMenuItem item : itemList) {
            String compareID = "";
            switch (type) {
                case 0: {
                    compareID = item.getText();
                    break;
                }
                case 1: {
                    compareID = item.getActionCommand();
                }
            }
            if (!compareID.equalsIgnoreCase(menuID)) continue;
            return item;
        }
        return null;
    }

    public Collection<JMenuItem> getMenuItems() {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        MenuElement[] miList = this.client.getSubElements();
        this.getMenuItems(miList, menuItems);
        return menuItems;
    }

    private void getMenuItems(MenuElement[] miList, ArrayList<JMenuItem> items) {
        int i = 0;
        while (i < miList.length) {
            if (miList[i] instanceof JPopupMenu) {
                JPopupMenu popup = (JPopupMenu)miList[i];
                elements = popup.getSubElements();
                this.getMenuItems(elements, items);
            } else if (miList[i] instanceof JMenu) {
                JMenu menu = (JMenu)miList[i];
                elements = menu.getSubElements();
                this.getMenuItems(elements, items);
            } else if (miList[i] instanceof JMenuItem) {
                items.add((JMenuItem)miList[i]);
            }
            ++i;
        }
    }
}

