/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.slider;

import com.jmorgan.beans.JMBean;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogarithmicRangeModelDelegate
extends JMBean
implements ChangeListener {
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private JSlider slider;
    private int minimum;
    private int maximum;
    private double value;

    public LogarithmicRangeModelDelegate(JSlider slider, int min, int max) {
        this.slider = slider;
        this.addChangeListeners();
        this.setMinimum(min);
        this.setMaximum(max);
        this.computeValue();
        slider.addChangeListener(this);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        double exponent = this.getExponent();
        double sliderValue = Math.pow(value, 1.0 / exponent) + (double)this.slider.getMinimum();
        this.slider.setValue((int)sliderValue);
    }

    public JSlider getSlider() {
        return this.slider;
    }

    private void addChangeListeners() {
        ChangeListener[] listeners = this.slider.getChangeListeners();
        if (listeners != null) {
            this.changeListeners.addAll(Arrays.asList(listeners));
            ChangeListener[] changeListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeListener listener = changeListenerArray[n2];
                this.slider.removeChangeListener(listener);
                ++n2;
            }
        }
    }

    private void computeValue() {
        double exponent = this.getExponent();
        int sliderValue = this.slider.getValue() - this.slider.getMinimum();
        this.value = Math.pow(sliderValue, exponent);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.computeValue();
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            if (listener == this) continue;
            listener.stateChanged(evt);
        }
    }

    private double getExponent() {
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int sliderDelta = maxValue - minValue;
        int thisDelta = this.maximum - this.minimum;
        return Math.log10(thisDelta) / Math.log10(sliderDelta);
    }
}

