/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.spinner;

import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.spinner.SpinEvent;
import com.jmorgan.swing.spinner.SpinListener;
import com.jmorgan.swing.spinner.Spinner;

public class NumberSpinner
extends Spinner
implements SpinListener {
    private double spinIncrement;
    private double spinMinimum;
    private double spinMaximum;
    private boolean isSpinMinimumSet = false;
    private boolean isSpinMaximumSet = false;

    public NumberSpinner(NumberField nf) {
        this(nf, 1.0);
    }

    public NumberSpinner(NumberField nf, double spinIncrement) {
        super(nf);
        this.spinIncrement = spinIncrement;
        this.addSpinListener(this);
    }

    public NumberSpinner(NumberField nf, double spinIncrement, double spinMinimum, double spinMaximum) {
        this(nf, spinIncrement);
        if (spinMaximum < spinMinimum) {
            throw new IllegalArgumentException("Spin Maximum cannot be less than spin Minimum.");
        }
        this.spinMinimum = spinMinimum;
        this.spinMaximum = spinMaximum;
        this.isSpinMaximumSet = true;
        this.isSpinMinimumSet = true;
    }

    @Override
    public void spinUp(SpinEvent e) {
        this.spin(e);
    }

    @Override
    public void spinDown(SpinEvent e) {
        this.spin(e);
    }

    private synchronized void spin(SpinEvent e) {
        NumberField field = (NumberField)e.getSource();
        if (field.isNull()) {
            return;
        }
        int caretPos = field.getCaretPosition();
        double n = field.getNumber();
        this.oldValue = n;
        int spinDir = e.getSpinDirection() == 1 ? -1 : 1;
        n += this.spinIncrement * (double)spinDir;
        if (this.isSpinMinimumSet && n < this.spinMinimum) {
            n = this.spinMinimum;
        }
        if (this.isSpinMaximumSet && n > this.spinMaximum) {
            n = this.spinMaximum;
        }
        field.setNumber(n);
        field.requestFocus();
        if (field.getText().length() < caretPos) {
            caretPos = 0;
        }
        field.setCaretPosition(caretPos);
    }

    public double getSpinIncrement() {
        return this.spinIncrement;
    }

    public void setSpinIncrement(double newSpinIncrement) {
        this.spinIncrement = newSpinIncrement;
    }

    public double getSpinMinimum() {
        return this.spinMinimum;
    }

    public void setSpinMinimum(double newSpinMinimum) {
        this.spinMinimum = newSpinMinimum;
        this.isSpinMinimumSet = true;
    }

    public double getSpinMaximum() {
        return this.spinMaximum;
    }

    public void setSpinMaximum(double newSpinMaximum) {
        this.spinMaximum = newSpinMaximum;
        this.isSpinMaximumSet = true;
    }

    public boolean isSpinMinimumSet() {
        return this.isSpinMinimumSet;
    }

    public boolean isSpinMaximumSet() {
        return this.isSpinMaximumSet;
    }
}

