/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.splitpane;

import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.splitpane.SplitPaneDivider;
import com.jmorgan.swing.splitpane.SplitPaneLayout;
import com.jmorgan.swing.util.HoverColorController;
import com.jmorgan.util.Pair;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.UIManager;

public class SplitPane
extends JMPanel
implements ComponentListener,
VetoableChangeListener {
    private SplitPaneLayout splitPaneLayout;
    private int rows;
    private int columns;
    private ArrayList<SplitPaneDivider> rowDividers;
    private ArrayList<SplitPaneDivider> columnDividers;

    public SplitPane() {
        this(0, 0);
    }

    public SplitPane(int rows, int columns) {
        SplitPaneDivider divider;
        this.rows = rows;
        this.columns = columns;
        this.splitPaneLayout = new SplitPaneLayout(rows, columns);
        super.setLayout(this.splitPaneLayout);
        HoverColorController hc = new HoverColorController(UIManager.getColor("SplitPane.dividerFocusColor"));
        this.rowDividers = new ArrayList();
        int r = 0;
        while (r < rows - 1) {
            divider = new SplitPaneDivider(r, 1);
            divider.addVetoableChangeListener(this);
            this.rowDividers.add(divider);
            this.add(divider);
            hc.addComponent(divider);
            divider.addComponentListener(this);
            ++r;
        }
        this.columnDividers = new ArrayList();
        int c = 0;
        while (c < columns - 1) {
            divider = new SplitPaneDivider(c, 0);
            divider.addVetoableChangeListener(this);
            this.columnDividers.add(divider);
            this.add(divider);
            hc.addComponent(divider);
            divider.addComponentListener(this);
            ++c;
        }
    }

    public Component add(Component comp, int row, int col) {
        super.add(comp, new Pair<Integer, Integer>(row, col));
        return comp;
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof SplitPaneDivider) {
            return super.add(comp);
        }
        return this.add(comp, -1, -1);
    }

    @Override
    public Component add(Component comp, int index) {
        int rows = this.splitPaneLayout.getMaxRows();
        int cols = this.splitPaneLayout.getMaxColumns();
        int row = Math.floorDiv(index, rows);
        int col = Math.floorMod(index, cols);
        super.add(comp, new Pair<Integer, Integer>(row, col));
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints) {
        throw new UnsupportedOperationException("This method is unsupoorted for SplitPane.");
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        throw new UnsupportedOperationException("This method is unsupoorted for SplitPane.");
    }

    public void remove(int row, int column) {
        Component component = this.splitPaneLayout.getComponentAt(row, column);
        this.remove(component);
    }

    @Override
    public void remove(Component comp) {
        if (comp == null) {
            return;
        }
        Pair<Integer, Integer> componentLocation = this.splitPaneLayout.getLocationOf(comp);
        super.remove(comp);
        if (comp instanceof SplitPaneDivider) {
            SplitPaneDivider divider = (SplitPaneDivider)comp;
            int orientation = divider.getOrientation();
            int order = divider.getOrder();
            ArrayList<SplitPaneDivider> list = switch (orientation) {
                case 1 -> {
                    --this.rows;
                    yield this.rowDividers;
                }
                case 0 -> {
                    --this.columns;
                    yield this.columnDividers;
                }
                default -> null;
            };
            list.remove(divider);
            for (SplitPaneDivider listDivider : list) {
                int listDividerOrder = listDivider.getOrder();
                if (listDividerOrder < order) continue;
                listDivider.setOrder(listDividerOrder - 1);
            }
        } else {
            int columnCount;
            int rowCount = this.splitPaneLayout.getMaxRows();
            if (rowCount < this.rows) {
                this.removeDividerOfRow((Integer)componentLocation.first);
            }
            if ((columnCount = this.splitPaneLayout.getMaxColumns()) < this.columns) {
                this.removeDividerOfColumn((Integer)componentLocation.second);
            }
        }
        this.invalidate();
        this.repaint();
    }

    private void removeDividerOfRow(int row) {
        SplitPaneDivider divider = this.rowDividers.get(row);
        this.remove(divider);
    }

    private void removeDividerOfColumn(int column) {
        SplitPaneDivider divider = this.columnDividers.get(column);
        this.remove(divider);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        SplitPaneDivider divider = (SplitPaneDivider)e.getComponent();
        int orientation = divider.getOrientation();
        int order = divider.getOrder();
        Point dividerLocation = divider.getLocation();
        Dimension dividerSize = divider.getSize();
        Dimension thisSize = this.getSize();
        Dimension workingSize = new Dimension(thisSize.width - (this.columns - 1) * dividerSize.width, thisSize.height - (this.rows - 1) * dividerSize.height);
        HashMap<Pair<Integer, Integer>, Component> locationMap = this.splitPaneLayout.getLocationMap();
        switch (orientation) {
            case 0: {
                Pair<Integer, Integer> leftCell = new Pair<Integer, Integer>(0, order);
                Pair<Integer, Integer> rightCell = new Pair<Integer, Integer>(0, order + 1);
                Component left = locationMap.get(leftCell);
                Component right = locationMap.get(rightCell);
                if (left == null) break;
                int leftWidth = dividerLocation.x - left.getX();
                int rightX = right.getX() + right.getWidth();
                int rightWidth = rightX - (dividerLocation.x + dividerSize.width);
                double leftPct = (double)leftWidth / (double)workingSize.width;
                double rightPct = (double)rightWidth / (double)workingSize.width;
                this.splitPaneLayout.setColumnWidth(order, leftPct);
                this.splitPaneLayout.setColumnWidth(order + 1, rightPct);
                break;
            }
            case 1: {
                Pair<Integer, Integer> aboveCell = new Pair<Integer, Integer>(order, 0);
                Pair<Integer, Integer> belowCell = new Pair<Integer, Integer>(order + 1, 0);
                Component above = locationMap.get(aboveCell);
                Component below = locationMap.get(belowCell);
                if (above == null) break;
                int aboveHeight = dividerLocation.y - above.getY();
                int belowY = below.getY() + below.getHeight();
                int belowHeight = belowY - (dividerLocation.y + dividerSize.height);
                double abovePct = (double)aboveHeight / (double)workingSize.height;
                double belowPct = (double)belowHeight / (double)workingSize.height;
                this.splitPaneLayout.setRowHeight(order, abovePct);
                this.splitPaneLayout.setRowHeight(order + 1, belowPct);
            }
        }
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        SplitPaneDivider divider = (SplitPaneDivider)evt.getSource();
        int order = divider.getOrder();
        int orientation = divider.getOrientation();
        int oldValue = (Integer)evt.getOldValue();
        int newValue = (Integer)evt.getNewValue();
        Dimension thisSize = this.getSize();
        Dimension dividerSize = divider.getSize();
        int lastColumnDivider = this.columns - 2;
        int lastRowDivider = this.rows - 2;
        switch (orientation) {
            case 0: {
                SplitPaneDivider rightDivider;
                if (order == 0 && newValue < 0) {
                    throw new PropertyVetoException("x cannot be less than 0", evt);
                }
                if (order == lastColumnDivider && newValue + dividerSize.width > thisSize.width) {
                    throw new PropertyVetoException("x cannot be greater than " + thisSize.width, evt);
                }
                if (order > 0 && newValue < oldValue) {
                    SplitPaneDivider leftDivider = this.columnDividers.get(order - 1);
                    Point leftDividerLocation = leftDivider.getLocation();
                    if (newValue < leftDividerLocation.x + dividerSize.width) {
                        throw new PropertyVetoException(String.format("Divider %d cannot move left of divider %d", order, order - 1), evt);
                    }
                }
                if (order >= lastColumnDivider || newValue <= oldValue || newValue + dividerSize.width <= (rightDivider = this.columnDividers.get(order + 1)).getX()) break;
                throw new PropertyVetoException(String.format("Divider %d cannot move right of divider %d", order, order + 1), evt);
            }
            case 1: {
                SplitPaneDivider belowDivider;
                if (order == 0 && newValue < 0) {
                    throw new PropertyVetoException("y cannot be less than 0", evt);
                }
                if (order == lastRowDivider && newValue + dividerSize.height > thisSize.height) {
                    throw new PropertyVetoException("y cannot be greater than " + thisSize.height, evt);
                }
                if (order > 0 && newValue < oldValue) {
                    SplitPaneDivider aboveDivider = this.rowDividers.get(order - 1);
                    Point aboveDividerLocation = aboveDivider.getLocation();
                    if (newValue < aboveDividerLocation.y + dividerSize.height) {
                        throw new PropertyVetoException(String.format("Divider %d cannot move above of divider %d", order, order - 1), evt);
                    }
                }
                if (order >= lastRowDivider || newValue <= oldValue || newValue + dividerSize.height <= (belowDivider = this.rowDividers.get(order + 1)).getY()) break;
                throw new PropertyVetoException(String.format("Divider %d cannot move below of divider %d", order, order + 1), evt);
            }
        }
    }
}

