/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.statusbar;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMProgressBar;
import com.jmorgan.swing.statusbar.StatusBarAvailableMemory;
import com.jmorgan.swing.statusbar.StatusBarClock;
import com.jmorgan.swing.statusbar.StatusBarTotalMemory;
import com.jmorgan.swing.util.ComponentConstants;
import com.jmorgan.swing.util.GUIServices;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.JProgressBar;

public class StatusBar
extends JMPanel {
    private JMPanel contentPane = null;
    private JMLabel statusMessage;
    private String defaultStatusMessage = "Ready";
    private JMProgressBar progressBar;

    public StatusBar(Container c) {
        this.setBorder(ComponentConstants.controlBorder);
        this.setLayout(new BorderLayout());
        this.contentPane = new JMPanel();
        this.contentPane.setBorder(ComponentConstants.controlBorder);
        this.contentPane.setLayout(new FlowLayout(2));
        this.add((Component)this.contentPane, "East");
        this.statusMessage = new JMLabel(this.defaultStatusMessage);
        this.statusMessage.setBorder(ComponentConstants.controlBorder);
        this.add((Component)this.statusMessage, "Center");
        Container parentContent = GUIServices.getContentPane(c);
        if (parentContent == null) {
            return;
        }
        LayoutManager lm = c.getLayout();
        if (lm instanceof FlowLayout) {
            parentContent.add((Component)this, 4);
        }
        if (lm instanceof BorderLayout) {
            parentContent.add((Component)this, "South");
        }
    }

    public JProgressBar addProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JMProgressBar();
        }
        this.contentPane.add(this.progressBar);
        return this.progressBar;
    }

    public JProgressBar addProgressBar(int maximum) {
        this.addProgressBar();
        this.progressBar.setMaximum(maximum);
        return this.progressBar;
    }

    public void removeProgressBar() {
        if (this.progressBar == null) {
            return;
        }
        this.contentPane.remove(this.progressBar);
        this.revalidate();
    }

    public void addClock() {
        new StatusBarClock(this);
    }

    public void addTotalMemory() {
        new StatusBarTotalMemory(this);
    }

    public void addAvailableMemory() {
        new StatusBarAvailableMemory(this);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void setDefaultStatusMessage(String defaultStatusMessage) {
        this.defaultStatusMessage = defaultStatusMessage;
    }

    public void setMessage(Object msg) {
        new AsynchMethodInvoker((Object)this.statusMessage, "setText", (Object)msg.toString());
    }

    public void setMessage() {
        this.setMessage(this.defaultStatusMessage);
    }
}

