/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.style;

import com.jmorgan.swing.style.GUIStyle;
import java.awt.Color;
import javax.swing.UIManager;

public class ColorStyle
extends GUIStyle {
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";

    public static final ColorStyle getDefaultColorStyle(String uiType) {
        Color foreground = UIManager.getColor(uiType + ".foreground");
        Color background = UIManager.getColor(uiType + ".background");
        if (foreground == null || background == null) {
            return null;
        }
        ColorStyle colorStyle = new ColorStyle(foreground, background);
        return colorStyle;
    }

    public ColorStyle() {
    }

    public ColorStyle(Color foreground, Color background) {
        this();
        this.setForeground(foreground);
        this.setBackground(background);
    }

    public Color getBackground() {
        return (Color)this.getStyle(BACKGROUND);
    }

    public Color getForeground() {
        return (Color)this.getStyle(FOREGROUND);
    }

    public void setBackground(Color color) {
        this.setStyle(BACKGROUND, color);
    }

    public void setForeground(Color color) {
        this.setStyle(FOREGROUND, color);
    }
}

