/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.lang.MethodInvoker;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public abstract class AbstractTableCellEditor
implements TableCellEditor {
    private CopyOnWriteArrayList<CellEditorListener> cellEditorListeners;

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireChangeEvent("editingStopped");
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireChangeEvent("editingCanceled");
    }

    private void fireChangeEvent(String methodToCall) {
        if (this.cellEditorListeners != null) {
            for (CellEditorListener listener : this.cellEditorListeners) {
                ChangeEvent event = new ChangeEvent(this);
                MethodInvoker eventMethod = new MethodInvoker((Object)listener, methodToCall, event);
                try {
                    eventMethod.invoke();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        if (listener == null) {
            return;
        }
        if (this.cellEditorListeners == null) {
            this.cellEditorListeners = new CopyOnWriteArrayList();
        }
        if (!this.cellEditorListeners.contains(listener)) {
            this.cellEditorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        if (listener == null || this.cellEditorListeners == null) {
            return;
        }
        CopyOnWriteArrayList<CellEditorListener> copyOnWriteArrayList = this.cellEditorListeners;
        synchronized (copyOnWriteArrayList) {
            this.cellEditorListeners.remove(listener);
        }
    }
}

