/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.beans.persistence.PersistenceService;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.TableCellEditorRenderer;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BeanColumnModel<BeanType>
extends DefaultTableColumnModel {
    private ArrayList<TableColumn> hiddenColumns;
    private TableCellEditorRenderer editorRenderer = new TableCellEditorRenderer();
    private BeanTableModel<BeanType> tableModel;

    static {
        PersistenceService.setTransient(BeanColumnModel.class, "listenerList");
    }

    public BeanColumnModel() {
    }

    public BeanColumnModel(BeanTableModel<BeanType> tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public BeanColumnModel(Class<BeanType> beanClass) {
        this();
        ArrayList<String> propertyNames = BeanService.getPropertyNames(beanClass);
        Collections.sort(propertyNames);
        this.init(propertyNames.toArray(new String[propertyNames.size()]));
    }

    public BeanColumnModel(String ... propertyNames) {
        this();
        this.init(propertyNames);
    }

    private void init(String ... propertyNames) {
        int index = 0;
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            String columnName = StringUtility.getDisplayableTitle(propertyName);
            int headerWidth = 75;
            TableColumn tc = new TableColumn(index++, headerWidth);
            tc.setHeaderValue(columnName);
            tc.setIdentifier(propertyName);
            tc.setCellEditor(this.editorRenderer);
            tc.setCellRenderer(this.editorRenderer);
            this.addColumn(tc);
            ++n2;
        }
    }

    public BeanTableModel<BeanType> getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(BeanTableModel<BeanType> tableModel) {
        int columnCount = tableModel.getColumnCount();
        int c = 0;
        while (c < columnCount) {
            String columnName = tableModel.getColumnName(c);
            String headerName = StringUtility.getDisplayableTitle(columnName);
            int headerWidth = 75;
            TableColumn tc = new TableColumn(c, headerWidth);
            tc.setHeaderValue(headerName);
            tc.setIdentifier(columnName);
            tc.setCellEditor(this.editorRenderer);
            tc.setCellRenderer(this.editorRenderer);
            this.addColumn(tc);
            ++c;
        }
        this.tableModel = tableModel;
    }

    public void setRenderer(String columnNameRegex, TableCellRenderer renderer) {
        if (CollectionUtility.isEmpty(this.tableColumns)) {
            return;
        }
        for (TableColumn tc : this.tableColumns) {
            if (!Pattern.matches(columnNameRegex, tc.getIdentifier().toString())) continue;
            tc.setCellRenderer(renderer);
        }
    }

    public void setEditor(String columnNameRegex, TableCellEditor editor) {
        if (this.tableColumns == null || this.tableColumns.size() == 0) {
            return;
        }
        for (TableColumn tc : this.tableColumns) {
            if (!Pattern.matches(columnNameRegex, tc.getIdentifier().toString())) continue;
            tc.setCellEditor(editor);
        }
    }

    public void addComputedColumn(String columnName, Class<?> columnType) {
        TableColumn tc = new TableColumn(this.tableColumns.size(), 75);
        tc.setHeaderValue(StringUtility.getDisplayableTitle(columnName));
        tc.setIdentifier(columnName);
        this.addColumn(tc);
    }

    public void setColumnWidth(String columnName, int width) {
        try {
            this.setColumnWidth(this.getColumnIndex(columnName), width);
        }
        catch (IllegalArgumentException e) {
            System.err.printf("BeanColumnModel.setColumnWidth(columnName=%s, width=%d):  %s\n", columnName, width, e.getMessage());
            e.printStackTrace();
        }
    }

    public void setColumnWidth(int index, int width) {
        TableColumn tableColumn = (TableColumn)this.tableColumns.get(index);
        tableColumn.setPreferredWidth(width);
        tableColumn.setWidth(width);
    }

    public void setColumnTitle(String columnName, String columnTitle) throws IllegalArgumentException {
        int columnIndex = this.getColumnIndex(columnName);
        this.setColumnTitle(columnIndex, columnTitle);
    }

    public void setColumnTitle(int index, String columnTitle) throws ArrayIndexOutOfBoundsException {
        TableColumn tableColumn = (TableColumn)this.tableColumns.get(index);
        tableColumn.setHeaderValue(columnTitle);
    }

    public ArrayList<String> getColumnTitles() {
        ArrayList<String> titles = new ArrayList<String>(this.tableColumns.size());
        for (TableColumn tc : this.tableColumns) {
            titles.add(tc.getHeaderValue().toString());
        }
        return titles;
    }

    public void hideColumns(String ... columnNames) {
        if (columnNames == null || columnNames.length == 0) {
            return;
        }
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            this.hideColumn(columnName);
            ++n2;
        }
    }

    public void hideColumn(String columnName) {
        TableColumn columnToHide = null;
        for (TableColumn tc : this.tableColumns) {
            if (!tc.getIdentifier().equals(columnName)) continue;
            columnToHide = tc;
            break;
        }
        if (columnToHide == null) {
            return;
        }
        this.hideColumn(columnToHide);
    }

    public void hideColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            return;
        }
        if (this.hiddenColumns == null) {
            this.hiddenColumns = new ArrayList();
        }
        if (this.tableColumns.contains(tableColumn)) {
            this.tableColumns.remove(tableColumn);
            this.hiddenColumns.add(tableColumn);
        }
    }

    public void showColumns(String ... columnNames) {
        if (this.hiddenColumns == null || this.hiddenColumns.size() == 0 || columnNames == null || columnNames.length == 0) {
            return;
        }
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            this.showColumn(columnName);
            ++n2;
        }
    }

    public void showColumn(String columnName) {
        if (this.hiddenColumns == null || this.hiddenColumns.size() == 0 || columnName == null) {
            return;
        }
        TableColumn columnToShow = null;
        for (TableColumn tc : this.hiddenColumns) {
            if (!tc.getIdentifier().equals(columnName)) continue;
            columnToShow = tc;
            break;
        }
        if (columnToShow == null) {
            return;
        }
        this.showColumn(columnToShow);
    }

    public void showColumn(TableColumn tableColumn) {
        if (this.hiddenColumns == null || this.hiddenColumns.size() == 0 || tableColumn == null) {
            return;
        }
        if (this.hiddenColumns.contains(tableColumn)) {
            this.hiddenColumns.remove(tableColumn);
            this.tableColumns.add(tableColumn);
        }
    }

    public void setColumnOrder(ArrayList<String> columnNames) {
        if (columnNames == null || columnNames.size() == 0) {
            return;
        }
        String[] cNames = columnNames.toArray(new String[columnNames.size()]);
        this.setColumnOrder(cNames);
    }

    public void setColumnOrder(String ... columnNames) {
        if (columnNames == null || columnNames.length == 0) {
            return;
        }
        int currentColumnCount = this.tableColumns.size();
        Object[] tableColumns = new TableColumn[currentColumnCount];
        this.tableColumns.copyInto(tableColumns);
        this.tableColumns.clear();
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            int i = 0;
            while (i < tableColumns.length) {
                if (tableColumns[i] != null && ((TableColumn)tableColumns[i]).getIdentifier().equals(columnName)) {
                    this.tableColumns.addElement(tableColumns[i]);
                    tableColumns[i] = null;
                }
                ++i;
            }
            ++n2;
        }
        int i = 0;
        while (i < tableColumns.length) {
            if (tableColumns[i] != null) {
                this.tableColumns.addElement(tableColumns[i]);
            }
            ++i;
        }
    }

    public void reset() {
        if (this.hiddenColumns != null) {
            this.hiddenColumns.clear();
        }
        if (this.tableColumns != null) {
            this.tableColumns.clear();
        }
    }
}

