/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.table.BeanTableModel;
import java.util.ArrayList;
import javax.swing.RowFilter;

public class BeanRowFilter<BeanType>
extends RowFilter<BeanTableModel<BeanType>, Integer> {
    private BeanTableModel<BeanType> tableModel;
    private PropertyValueRule<BeanType> filteringRule;
    private ArrayList<BeanType> filteredRows = new ArrayList();

    public BeanRowFilter(BeanTableModel<BeanType> tableModel) {
        this.setTableModel(tableModel);
        this.setFilteringRule(new PropertyValueRule());
    }

    public BeanTableModel<BeanType> getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(BeanTableModel<BeanType> tableModel) {
        this.tableModel = tableModel;
        this.tableModel.setRowFilter(this);
    }

    public PropertyValueRule<BeanType> getFilteringRule() {
        return this.filteringRule;
    }

    public void setFilteringRule(PropertyValueRule<BeanType> rule) {
        this.filteringRule = rule;
        this.applyFilter();
    }

    public void addPropertyValueMap(String propertyName, Object value) {
        this.filteringRule.addPropertyValueMap(propertyName, value);
        this.applyFilter();
    }

    public void addPropertyValueMap(String propertyName, Object value, int comparisonType) throws IllegalArgumentException {
        this.filteringRule.addPropertyValueMap(propertyName, value, comparisonType);
        this.applyFilter();
    }

    public void addPropertyValueMap(String propertyName, Object value, String operator) throws IllegalArgumentException {
        this.filteringRule.addPropertyValueMap(propertyName, value, operator);
        this.applyFilter();
    }

    public void removePropertyValueMap(String propertyName) {
        this.filteringRule.removePropertyValueMap(propertyName);
        this.applyFilter();
    }

    public ArrayList<BeanType> getFilteredRows() {
        return this.filteredRows;
    }

    public void clearMap() {
        this.filteringRule.clearMap();
    }

    public void clearRows() {
        this.filteredRows.clear();
    }

    private void applyFilter() {
        ArrayList<BeanType> rowsToRetest = new ArrayList<BeanType>(this.filteredRows);
        this.filteredRows.clear();
        int rowCount = this.tableModel.getRowCount();
        int row = rowCount - 1;
        while (row >= 0) {
            BeanType bean = this.tableModel.getValue(row);
            if (!this.include(bean)) {
                this.tableModel.deleteRow(row);
            }
            --row;
        }
        if (rowsToRetest.size() > 0) {
            this.tableModel.addAll(rowsToRetest);
        }
    }

    @Override
    public boolean include(RowFilter.Entry<? extends BeanTableModel<BeanType>, ? extends Integer> entry) {
        if (this.filteringRule == null || this.filteringRule.getRuleCount() == 0) {
            return true;
        }
        BeanTableModel<BeanType> tableModel = entry.getModel();
        BeanType row = tableModel.getValue(entry.getIdentifier());
        return this.include(row);
    }

    public boolean include(BeanType row) {
        if (row == null) {
            return false;
        }
        if (this.filteringRule == null || this.filteringRule.getRuleCount() == 0) {
            return true;
        }
        this.filteringRule.setBean(row);
        boolean include = this.filteringRule.isTrue();
        if (!include) {
            this.filteredRows.add(row);
        }
        return include;
    }
}

