/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.ColorBeanTableModelPropertyValueRule;
import com.jmorgan.swing.table.DisplayExpressionBeanTableModelPropertyValueRule;
import com.jmorgan.swing.table.FontBeanTableModelPropertyValueRule;
import com.jmorgan.swing.table.FormattingBeanTableModelPropertyValueRule;
import com.jmorgan.text.DateTimeFormat;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.collection.CollectionUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class BeanTableCellRenderer<BeanType>
extends DefaultTableCellRenderer {
    private ArrayList<DisplayExpressionBeanTableModelPropertyValueRule<BeanType>> selectedDisplayRules = new ArrayList();
    private ArrayList<DisplayExpressionBeanTableModelPropertyValueRule<BeanType>> unSelectedDisplayRules = new ArrayList();
    private ArrayList<FormattingBeanTableModelPropertyValueRule<? extends Format, BeanType>> formattingRules = new ArrayList();
    private ArrayList<FontBeanTableModelPropertyValueRule<BeanType>> selectedFontRules = new ArrayList();
    private ArrayList<FontBeanTableModelPropertyValueRule<BeanType>> unSelectedFontRules = new ArrayList();
    private ArrayList<ColorBeanTableModelPropertyValueRule<BeanType>> selectedForegroundColorRules = new ArrayList();
    private ArrayList<ColorBeanTableModelPropertyValueRule<BeanType>> unSelectedForegroundColorRules = new ArrayList();
    private ArrayList<ColorBeanTableModelPropertyValueRule<BeanType>> selectedBackgroundColorRules = new ArrayList();
    private ArrayList<ColorBeanTableModelPropertyValueRule<BeanType>> unSelectedBackgroundColorRules = new ArrayList();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color;
        Color evenBackground;
        Color background;
        if (table == null) {
            return this;
        }
        BeanTableModel tableModel = (BeanTableModel)table.getModel();
        Object beanValue = tableModel.getValue(table.convertRowIndexToModel(row));
        if (beanValue == null) {
            return this;
        }
        ArrayList<DisplayExpressionBeanTableModelPropertyValueRule<BeanType>> displayExpressionRuleSet = isSelected ? this.selectedDisplayRules : this.unSelectedDisplayRules;
        ArrayList<FontBeanTableModelPropertyValueRule<BeanType>> fontRuleSet = isSelected ? this.selectedFontRules : this.unSelectedFontRules;
        ArrayList<ColorBeanTableModelPropertyValueRule<BeanType>> foregroundColorRuleSet = isSelected ? this.selectedForegroundColorRules : this.unSelectedForegroundColorRules;
        ArrayList<ColorBeanTableModelPropertyValueRule<BeanType>> backgroundColorRuleSet = isSelected ? this.selectedBackgroundColorRules : this.unSelectedBackgroundColorRules;
        String displayValue = value == null ? "" : value.toString();
        this.setText(displayValue.toString());
        Color foreground = isSelected ? table.getSelectionForeground() : table.getForeground();
        this.setForeground(foreground);
        Color color2 = background = isSelected ? table.getSelectionBackground() : table.getBackground();
        if (row % 2 == 0 && (evenBackground = UIManager.getColor("Table.alternateBackground")) != null) {
            background = evenBackground;
        }
        if (isSelected) {
            background = table.getSelectionBackground();
        }
        this.setBackground(background);
        this.setFont(table.getFont());
        boolean ruleApplied = false;
        for (DisplayExpressionBeanTableModelPropertyValueRule displayExpressionBeanTableModelPropertyValueRule : displayExpressionRuleSet) {
            displayExpressionBeanTableModelPropertyValueRule.setBean(beanValue);
            if (!displayExpressionBeanTableModelPropertyValueRule.isTrue()) continue;
            String displayExpression = displayExpressionBeanTableModelPropertyValueRule.getDisplayExpression();
            displayValue = BeanService.getPropertyValue(beanValue, displayExpression);
            ruleApplied = true;
            break;
        }
        if (CollectionUtility.isNotEmpty(this.formattingRules)) {
            for (FormattingBeanTableModelPropertyValueRule formattingBeanTableModelPropertyValueRule : this.formattingRules) {
                Object valueToDisplay;
                Class<?> matchingType = formattingBeanTableModelPropertyValueRule.getMatchingType();
                Object object = valueToDisplay = ruleApplied ? displayValue : value;
                if (!matchingType.isInstance(valueToDisplay)) continue;
                formattingBeanTableModelPropertyValueRule.setBean(beanValue);
                if (!formattingBeanTableModelPropertyValueRule.isTrue()) continue;
                Object formatter = formattingBeanTableModelPropertyValueRule.getFormatter();
                if (valueToDisplay instanceof DateTime) {
                    DateTimeFormat dtFormatter = (DateTimeFormat)formatter;
                    displayValue = dtFormatter.format((DateTime)valueToDisplay);
                } else {
                    displayValue = ((Format)formatter).format(valueToDisplay);
                }
                ruleApplied = true;
                break;
            }
        }
        this.setText(String.valueOf(displayValue));
        for (FontBeanTableModelPropertyValueRule fontBeanTableModelPropertyValueRule : fontRuleSet) {
            fontBeanTableModelPropertyValueRule.setBean(beanValue);
            if (!fontBeanTableModelPropertyValueRule.isTrue()) continue;
            Font font = fontBeanTableModelPropertyValueRule.getFont();
            this.setFont(font);
            ruleApplied = true;
            break;
        }
        for (ColorBeanTableModelPropertyValueRule colorBeanTableModelPropertyValueRule : foregroundColorRuleSet) {
            colorBeanTableModelPropertyValueRule.setBean(beanValue);
            if (!colorBeanTableModelPropertyValueRule.isTrue()) continue;
            color = colorBeanTableModelPropertyValueRule.getColor();
            this.setForeground(color);
            ruleApplied = true;
            break;
        }
        for (ColorBeanTableModelPropertyValueRule colorBeanTableModelPropertyValueRule : backgroundColorRuleSet) {
            colorBeanTableModelPropertyValueRule.setBean(beanValue);
            if (!colorBeanTableModelPropertyValueRule.isTrue()) continue;
            color = colorBeanTableModelPropertyValueRule.getColor();
            this.setBackground(color);
            ruleApplied = true;
            break;
        }
        if (ruleApplied) {
            return this;
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public void addFormattingRule(FormattingBeanTableModelPropertyValueRule<? extends Format, BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.formattingRules.add(rule);
    }

    public void addSelectedDisplayRule(DisplayExpressionBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.selectedDisplayRules.add(rule);
    }

    public void addUnSelectedDisplayRule(DisplayExpressionBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.unSelectedDisplayRules.add(rule);
    }

    public void addSelectedFontRule(FontBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.selectedFontRules.add(rule);
    }

    public void addUnSelectedFontRule(FontBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.unSelectedFontRules.add(rule);
    }

    public void addSelectedForegroundColorRule(ColorBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.selectedForegroundColorRules.add(rule);
    }

    public void addUnSelectedForegroundColorRule(ColorBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.unSelectedForegroundColorRules.add(rule);
    }

    public void addSelectedBackgroundColorRule(ColorBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.selectedBackgroundColorRules.add(rule);
    }

    public void addUnSelectedBackgroundColorRule(ColorBeanTableModelPropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        this.unSelectedBackgroundColorRules.add(rule);
    }
}

