/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.BeanModelProperty;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.table.BeanRowFilter;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class BeanTableModel<BeanType>
implements TableModel {
    private static final Logger logger = Logger.getLogger(BeanTableModel.class.getName());
    private final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private Class<BeanType> modelElementType;
    private Vector<BeanType> model;
    private HashMap<String, BeanModelProperty> modelMap;
    private boolean modelMapDefined;
    private ArrayList<TableModelListener> tableModelListeners = new ArrayList();
    private ArrayList<Integer> editableColumns;
    private boolean isEditable;
    private ArrayList<PropertyValueRule<BeanType>> rowEditabilityRules;
    private HashMap<Integer, PropertyValueRule<BeanType>> cellEditabilityRules;
    private BeanRowFilter<BeanType> rowFilter;

    public BeanTableModel() {
        this.model = new Vector();
        this.modelMap = new HashMap();
    }

    public BeanTableModel(Class<BeanType> type) {
        this();
        this.setModelElementType(type);
    }

    public Class<BeanType> getModelElementType() {
        return this.modelElementType;
    }

    public void setModelElementType(Class<BeanType> type) {
        this.modelElementType = type;
        this.setupModelMap(this.modelElementType);
    }

    private void setupModelMap(Class<BeanType> type) {
        ArrayList<String> fields = BeanService.getPropertyNames(type);
        Collections.sort(fields);
        this.defineModelMap(type, fields);
    }

    private void defineModelMap(Class<BeanType> type, ArrayList<String> fields) {
        if (this.modelMapDefined) {
            return;
        }
        this.modelMapDefined = true;
        Class<?> valueType = null;
        int i = 0;
        i = 0;
        while (i < fields.size()) {
            String fieldName = fields.get(i);
            try {
                valueType = BeanService.getPropertyType(type, fieldName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BeanModelProperty bmp = this.modelMap.get(fieldName);
            if (bmp == null) {
                bmp = new BeanModelProperty(i, valueType, fieldName);
                this.modelMap.put(fieldName, bmp);
            } else {
                int columnNumber = bmp.getColumnNumber();
                Class<?> columnType = bmp.getColumnClass();
                String displayExpression = bmp.getDisplayExpression();
                if (columnNumber == -1) {
                    bmp.setColumnNumber(i);
                }
                if (columnType == null) {
                    bmp.setColumnClass(valueType);
                }
                if (displayExpression == null) {
                    bmp.setDisplayExpression(fieldName);
                }
            }
            ++i;
        }
        ArrayList<BeanModelProperty> bmps = new ArrayList<BeanModelProperty>(this.modelMap.values());
        for (BeanModelProperty bmp : bmps) {
            if (bmp.getColumnNumber() == -1) {
                bmp.setColumnNumber(i++);
            }
            if (bmp.getColumnClass() != null || bmp.getBeanPropertyName().equals(bmp.getDisplayExpression())) continue;
            Object value = BeanService.getPropertyValue(type, bmp.getDisplayExpression());
            bmp.setColumnClass(value.getClass());
        }
        i = 0;
        Collections.sort(bmps);
        for (BeanModelProperty bmp : bmps) {
            int columnNumber = bmp.getColumnNumber();
            if (columnNumber >= Integer.MAX_VALUE) continue;
            bmp.setColumnNumber(i++);
        }
        TableModelEvent evt = new TableModelEvent(this, -1);
        for (TableModelListener listener : this.tableModelListeners) {
            listener.tableChanged(evt);
        }
    }

    public void setValueExpression(String columnName, String valueExpression) {
        BeanModelProperty bmp = this.modelMap.get(columnName);
        if (bmp != null) {
            bmp.setDisplayExpression(valueExpression);
        } else {
            bmp = new BeanModelProperty(-1, null, columnName);
            bmp.setDisplayExpression(valueExpression);
            this.modelMap.put(columnName, bmp);
        }
        bmp.setDisplayExpression(true);
    }

    public String getDisplayExpression(int column) {
        BeanModelProperty bmp = this.getBeanModelProperty(column);
        String displayExpression = bmp.getDisplayExpression();
        return displayExpression;
    }

    public void addComputedExpression(String columnName, String expression) {
        BeanModelProperty bmp = this.modelMap.get(columnName);
        if (bmp != null) {
            bmp.setDisplayExpression(expression);
            bmp.setComputed(true);
        } else {
            int columnNumber = -1;
            if (this.modelMapDefined) {
                for (BeanModelProperty bmp2 : this.modelMap.values()) {
                    int bmpCN = bmp2.getColumnNumber();
                    if (bmpCN <= columnNumber) continue;
                    columnNumber = bmpCN;
                }
            }
            ++columnNumber;
            Class<?> columnClass = null;
            if (this.model.size() > 0) {
                this.LOCK.readLock().lock();
                try {
                    BeanType base = this.model.get(0);
                    Object expressionValue = BeanService.getPropertyValue(base, expression);
                    if (expressionValue != null) {
                        columnClass = expressionValue.getClass();
                    }
                }
                finally {
                    this.LOCK.readLock().unlock();
                }
            }
            bmp = new BeanModelProperty(columnNumber, columnClass, columnName);
            bmp.setDisplayExpression(expression);
            bmp.setComputed(true);
            this.modelMap.put(columnName, bmp);
        }
    }

    public boolean isDisplayExpression(int columnNumber) {
        BeanModelProperty bmp = this.getBeanModelProperty(columnNumber);
        if (bmp == null) {
            return false;
        }
        return bmp.isDisplayExpression();
    }

    public boolean isComputedExpression(int columnNumber) {
        BeanModelProperty bmp = this.getBeanModelProperty(columnNumber);
        return bmp.isComputed();
    }

    public String getExpression(int columnNumber) {
        BeanModelProperty bmp = this.getBeanModelProperty(columnNumber);
        return bmp.getDisplayExpression();
    }

    @Override
    public int getColumnCount() {
        return this.modelMap.values().size();
    }

    @Override
    public int getRowCount() {
        return this.model.size();
    }

    public void setEditable() {
        this.isEditable = true;
    }

    public void setEditableColumns(String ... columnNames) {
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>(columnNames.length);
        Object object = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = object[n2];
            BeanModelProperty bmp = this.modelMap.get(columnName);
            if (bmp != null) {
                columnNumbers.add(bmp.getColumnNumber());
            }
            ++n2;
        }
        int[] editableColumns = new int[columnNumbers.size()];
        int i = 0;
        object = columnNumbers.iterator();
        while (object.hasNext()) {
            int columnNumber = (Integer)object.next();
            editableColumns[i++] = columnNumber;
        }
        this.setEditableColumns(editableColumns);
    }

    public void setEditableColumns(int ... columns) {
        this.isEditable = false;
        if (this.editableColumns == null) {
            this.editableColumns = new ArrayList();
        } else {
            this.editableColumns.clear();
        }
        int i = 0;
        while (i < columns.length) {
            this.editableColumns.add(columns[i]);
            ++i;
        }
    }

    public void addRowEditabilityRule(PropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        if (this.rowEditabilityRules == null) {
            this.rowEditabilityRules = new ArrayList();
        }
        this.rowEditabilityRules.add(rule);
    }

    public void addCellEditabilityRule(String columnName, PropertyValueRule<BeanType> rule) {
        int columnNumber = this.getColumnNumber(columnName);
        this.addCellEditabilityRule(columnNumber, rule);
    }

    public void addCellEditabilityRule(int columnNumber, PropertyValueRule<BeanType> rule) {
        if (rule == null) {
            return;
        }
        if (this.cellEditabilityRules == null) {
            this.cellEditabilityRules = new HashMap();
        }
        this.cellEditabilityRules.put(columnNumber, rule);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        PropertyValueRule<BeanType> rule;
        BeanType rowValue;
        if (this.rowEditabilityRules != null) {
            boolean allTrue = true;
            rowValue = this.getValue(row);
            for (PropertyValueRule<BeanType> rule2 : this.rowEditabilityRules) {
                rule2.setBean(rowValue);
                if (rule2.isTrue()) continue;
                allTrue = false;
                break;
            }
            if (!allTrue) {
                return false;
            }
        }
        if (this.cellEditabilityRules != null && (rule = this.cellEditabilityRules.get(column)) != null) {
            rowValue = this.getValue(row);
            rule.setBean(rowValue);
            if (rule.isTrue()) {
                return false;
            }
        }
        if (this.isEditable) {
            return true;
        }
        if (this.editableColumns != null) {
            for (int col : this.editableColumns) {
                if (col != column) continue;
                return true;
            }
        }
        return false;
    }

    public void setColumnEditable(String columnName, boolean editable) {
        int column = this.getColumnNumber(columnName);
        this.setColumnEditable(column, editable);
    }

    public void setColumnEditable(int column, boolean editable) {
        if (this.editableColumns == null) {
            if (!editable) {
                return;
            }
            this.editableColumns = new ArrayList();
            this.editableColumns.add(column);
            return;
        }
        ArrayList<Integer> looper = new ArrayList<Integer>(this.editableColumns);
        boolean columnFound = false;
        for (int col : looper) {
            if (col != column) continue;
            columnFound = true;
            if (editable) continue;
            this.editableColumns.remove(column);
        }
        if (!columnFound && editable) {
            this.editableColumns.add(column);
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        BeanModelProperty property = this.getBeanModelProperty(column);
        if (property == null) {
            return String.class;
        }
        Class<Object> type = property.getColumnClass();
        if (type == null) {
            this.LOCK.readLock().lock();
            try {
                if (this.model.size() > 0) {
                    BeanModelProperty bmp;
                    BeanType base = this.model.get(0);
                    Object expressionValue = BeanService.getPropertyValue(base, (bmp = this.getBeanModelProperty(column)).getDisplayExpression());
                    if (expressionValue != null) {
                        type = expressionValue.getClass();
                        bmp.setColumnClass(type);
                    }
                } else {
                    type = BeanService.getPropertyType(type, property.getDisplayExpression());
                }
            }
            finally {
                this.LOCK.readLock().unlock();
            }
        }
        switch (type.getName()) {
            case "boolean": {
                type = Boolean.class;
                break;
            }
            case "byte": {
                type = Byte.class;
                break;
            }
            case "short": {
                type = Short.class;
                break;
            }
            case "char": {
                type = Character.class;
                break;
            }
            case "int": {
                type = Integer.class;
                break;
            }
            case "long": {
                type = Long.class;
                break;
            }
            case "float": {
                type = Float.class;
                break;
            }
            case "double": {
                type = Double.class;
            }
        }
        return type;
    }

    public BeanRowFilter<BeanType> getRowFilter() {
        return this.rowFilter;
    }

    public void setRowFilter(BeanRowFilter<BeanType> rowFilter) {
        if (rowFilter == null) {
            System.out.printf("**** NOTICE:  BeanTableModel.setRowFilter(rowFilter=NULL)\n", new Object[0]);
        }
        this.rowFilter = rowFilter;
    }

    public void addAll(Collection<BeanType> rows) {
        if (CollectionUtility.isEmpty(rows)) {
            return;
        }
        this.LOCK.writeLock().lock();
        try {
            int firstRow = this.model.size();
            for (BeanType row : rows) {
                if (this.rowFilter != null && !this.rowFilter.include(row)) continue;
                this.model.add(row);
            }
            int lastRow = this.model.size();
            this.fireTableModelEvent(firstRow, lastRow, 0, true, false);
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
    }

    public void addRow(BeanType bean) {
        logger.finer("(bean): Starting.");
        if (this.rowFilter == null || this.rowFilter.include(bean)) {
            logger.finer("(bean): Matches filter or there is no filter.  Adding.");
            this.LOCK.writeLock().lock();
            try {
                this.model.add(bean);
            }
            finally {
                this.LOCK.writeLock().unlock();
            }
            logger.finer("(bean): Done adding new row to model. Calling handleNewRow().");
            this.handleNewRow();
        }
        logger.finer("(bean): Done.");
    }

    public void insertRow(BeanType bean, int beforeRow) {
        if (this.rowFilter == null || this.rowFilter.include(bean)) {
            this.LOCK.writeLock().lock();
            try {
                this.model.add(beforeRow, bean);
            }
            finally {
                this.LOCK.writeLock().unlock();
            }
            this.handleNewRow();
        }
    }

    private void handleNewRow() {
        logger.finer("(): Starting");
        int firstRow = this.model.size() - 1;
        if (firstRow < 0) {
            firstRow = 0;
        }
        int lastRow = firstRow;
        logger.finer("(): Calling fireTableModelEvent()");
        this.fireTableModelEvent(firstRow, lastRow, 0, true, false);
        logger.finer("(): Done");
    }

    public void deleteRow(int row) {
        this.LOCK.writeLock().lock();
        try {
            this.model.remove(row);
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
        this.fireTableModelEvent(row, row, 0, false, true);
    }

    public void deleteAll(int[] rows) {
        if (ArrayUtility.isEmpty(rows)) {
            return;
        }
        int maxModelRows = this.model.size();
        Arrays.sort(rows);
        int minRow = Integer.MAX_VALUE;
        int maxRow = -1;
        this.LOCK.writeLock().lock();
        try {
            int row = rows.length - 1;
            while (row >= 0) {
                if (rows[row] >= 0 && rows[row] < maxModelRows) {
                    if (rows[row] < minRow) {
                        minRow = rows[row];
                    }
                    if (rows[row] > maxRow) {
                        maxRow = rows[row];
                    }
                    this.model.remove(rows[row]);
                }
                --row;
                --maxModelRows;
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
        if (minRow == Integer.MAX_VALUE) {
            return;
        }
        this.fireTableModelEvent(minRow, maxRow, 0, false, true);
    }

    public void deleteRow(BeanType row) {
        this.deleteRow(this.model.indexOf(row));
    }

    public void deleteAll(Collection<BeanType> rows) {
        if (CollectionUtility.isEmpty(rows)) {
            return;
        }
        int minRow = this.model.size();
        int maxRow = -1;
        this.LOCK.writeLock().lock();
        try {
            for (BeanType row : rows) {
                int rowIndex = this.model.indexOf(row);
                if (rowIndex < minRow) {
                    minRow = rowIndex;
                }
                if (rowIndex > maxRow) {
                    maxRow = rowIndex;
                }
                this.model.remove(rowIndex);
            }
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
        this.fireTableModelEvent(minRow, maxRow, 0, false, true);
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean clearColumnModel) {
        int rowCount;
        if (this.rowFilter != null) {
            this.rowFilter.clearRows();
        }
        if ((rowCount = this.model.size()) == 0) {
            return;
        }
        this.model.clear();
        if (clearColumnModel) {
            this.modelMap.clear();
        }
        this.fireTableModelEvent(0, rowCount - 1, 0, false, true);
    }

    public ArrayList<BeanType> getModelData() {
        return this.getModelData(true);
    }

    public ArrayList<BeanType> getModelData(boolean useClone) {
        logger.finer(() -> LMG.log("(useClone=%b): Starting.", () -> useClone));
        if (useClone) {
            logger.finer(() -> LMG.log("(useClone=%b): Building clone.", () -> useClone));
            ArrayList<BeanType> clonedModel = new ArrayList<BeanType>(this.model.size());
            int attempts = 0;
            boolean acquired = false;
            while (!acquired && attempts++ < 10) {
                try {
                    try {
                        logger.finer(() -> LMG.log("(useClone=%b): Attempting to obtain a lock.", () -> useClone));
                        acquired = this.LOCK.readLock().tryLock(50L, TimeUnit.MILLISECONDS);
                        if (acquired) {
                            logger.finer(() -> LMG.log("(useClone=%b): Lock acquired.  Cloning model data.", () -> useClone));
                            for (BeanType element : this.model) {
                                BeanType clonedElement = BeanService.getClone(element);
                                if (clonedElement == null) {
                                    clonedModel.add(element);
                                    continue;
                                }
                                clonedModel.add(clonedElement);
                            }
                            logger.finer(() -> LMG.log("(useClone=%b): Cloning complete.", () -> useClone));
                        } else {
                            logger.finer(() -> LMG.log("(useClone=%b): Lock NOT acquired.  trying again.", () -> useClone));
                        }
                    }
                    catch (InterruptedException e) {
                        logger.finer(() -> LMG.log("(useClone=%b): Thread interrupted.", () -> useClone));
                        Thread.currentThread().interrupt();
                        if (!acquired) continue;
                        this.LOCK.readLock().unlock();
                        logger.finer(() -> LMG.log("(useClone=%b): Releasing lock.", () -> useClone));
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (acquired) {
                        this.LOCK.readLock().unlock();
                        logger.finer(() -> LMG.log("(useClone=%b): Releasing lock.", () -> useClone));
                    }
                    throw throwable;
                }
                if (!acquired) continue;
                this.LOCK.readLock().unlock();
                logger.finer(() -> LMG.log("(useClone=%b): Releasing lock.", () -> useClone));
            }
            logger.finer(() -> LMG.log("(useClone=%b): Retruning clonded model.", () -> useClone));
            return clonedModel;
        }
        logger.finer(() -> LMG.log("(useClone=%b): Returning new list with the model data.", () -> useClone));
        return new ArrayList<BeanType>(this.model);
    }

    public void setModelData(Collection<BeanType> modelData) {
        if (CollectionUtility.isNotEmpty(this.model) && CollectionUtility.isNotEmpty(modelData)) {
            this.model.clear();
            this.model.addAll(modelData);
            this.fireTableDataChanged();
        }
    }

    public BeanType getValue(int row) {
        int rowCount = this.getRowCount();
        if (row < 0 || row >= rowCount) {
            return null;
        }
        return this.model.get(row);
    }

    public ArrayList<BeanType> getValues(int[] rows) {
        ArrayList<BeanType> values = new ArrayList<BeanType>();
        if (!ArrayUtility.isEmpty(rows)) {
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                BeanType value = this.model.get(row);
                values.add(value);
                ++n2;
            }
        }
        return values;
    }

    @Override
    public Object getValueAt(int row, int column) {
        BeanModelProperty bmp;
        Object value;
        block14: {
            if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
                return null;
            }
            value = null;
            bmp = this.getBeanModelProperty(column);
            if (bmp != null) break block14;
            System.err.printf("BeanTableModel.getValueAt(row=%d, column=%d): BeanModelProperty not found in getBeanModelProperty(%d)\n", row, column, column);
            return "---ERROR---";
        }
        try {
            Object rowValue = null;
            this.LOCK.readLock().lock();
            try {
                rowValue = this.model.get(row);
            }
            finally {
                this.LOCK.readLock().unlock();
            }
            if (rowValue != null) {
                if (bmp.isComputed()) {
                    value = BeanService.getPropertyValue(rowValue, bmp.getDisplayExpression());
                } else {
                    String propertyName = bmp.getBeanPropertyName();
                    String displayExpression = bmp.getDisplayExpression();
                    value = BeanService.getPropertyValue(rowValue, propertyName);
                    if (value != null && !propertyName.equals(displayExpression)) {
                        try {
                            value = BeanService.getPropertyValue(value, displayExpression);
                        }
                        catch (Exception e) {
                            System.err.printf("BeanTableModel.getValueAt(row=%d, column=%d):  Error evaluating expression [%s] for property %s of %s.  Row Count=%d, Column Count=%d\n", row, column, displayExpression, propertyName, value.getClass().getName(), this.getRowCount(), this.getColumnCount());
                        }
                    }
                }
            } else {
                System.err.printf("BeanTableModel.getValueAt(row=%d, column=%d):  Row value is null.  Row Count=%d, Column Count=%d\n", row, column, this.getRowCount(), this.getColumnCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("The given row (" + row + ") or column (" + column + ") is out of range.");
        }
        try {
            String propertyName = this.getPropertyName(column);
            BeanType rowValue = null;
            this.LOCK.readLock().lock();
            try {
                rowValue = this.model.get(row);
            }
            finally {
                this.LOCK.readLock().unlock();
            }
            BeanService.setPropertyValue(rowValue, propertyName, value);
            if (this.rowFilter == null) {
                this.fireTableModelEvent(row, row, column, false, false);
            } else if (this.rowFilter.include(rowValue)) {
                this.fireTableModelEvent(row, row, column, false, false);
            } else {
                this.deleteRow(rowValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPropertyName(int column) throws NoSuchFieldException {
        if (column < 0 || column >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("The column " + column + " is out of range. It should be in the range 0 - " + this.getColumnCount());
        }
        BeanModelProperty property = this.getBeanModelProperty(column);
        String beanPropertyName = property.getBeanPropertyName();
        return beanPropertyName;
    }

    @Override
    public String getColumnName(int column) {
        String columnName = "";
        for (BeanModelProperty bmp : this.modelMap.values()) {
            if (bmp.getColumnNumber() != column) continue;
            columnName = bmp.getBeanPropertyName();
            break;
        }
        return columnName;
    }

    public int getColumnNumber(String columnName) {
        int columnNumber = -1;
        for (BeanModelProperty bmp : this.modelMap.values()) {
            if (!bmp.getBeanPropertyName().equals(columnName)) continue;
            columnNumber = bmp.getColumnNumber();
            break;
        }
        return columnNumber;
    }

    private BeanModelProperty getBeanModelProperty(int column) {
        if (this.model == null || this.model.size() == 0) {
            return null;
        }
        for (BeanModelProperty bmp : this.modelMap.values()) {
            if (bmp.getColumnNumber() != column) continue;
            return bmp;
        }
        return null;
    }

    public void sortModel(BeanComparator<BeanType> sorter) {
        Collections.sort(this.model, sorter);
        this.fireTableModelEvent(0, this.getRowCount(), 0, false, false);
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.tableModelListeners.add(listener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.tableModelListeners.remove(listener);
        }
    }

    public void fireTableDataChanged() {
        this.fireTableModelEvent(0, this.getRowCount(), -1, false, false);
    }

    private void fireTableModelEvent(int firstRow, int lastRow, int column, boolean isRowNew, boolean isRowDeleted) {
        int rowAction;
        if (this.getRowCount() == 0) {
            return;
        }
        int n = isRowNew ? 1 : (rowAction = isRowDeleted ? -1 : 0);
        if (rowAction != 0) {
            column = -1;
        }
        if (rowAction != -1) {
            firstRow = this.correctRowValue(firstRow);
            lastRow = this.correctRowValue(lastRow);
        }
        if (lastRow < firstRow) {
            int tmp = lastRow;
            lastRow = firstRow;
            firstRow = tmp;
        }
        TableModelEvent evt = new TableModelEvent(this, firstRow, lastRow, column, rowAction);
        for (TableModelListener listener : this.tableModelListeners) {
            try {
                listener.tableChanged(evt);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                System.err.printf("BeanTableModel.fireTableModelEvent(firstRow=%d, lastRow=%d, column=%d, isRowNew=%b, isRowDeleted=%b):  Model Size: %d\n", firstRow, lastRow, column, isRowNew, isRowDeleted, this.getRowCount());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                System.err.printf("BeanTableModel.fireTableModelEvent(firstRow=%d, lastRow=%d, column=%d, isRowNew=%b, isRowDeleted=%b):  Model Size: %d\n", firstRow, lastRow, column, isRowNew, isRowDeleted, this.getRowCount());
            }
        }
    }

    private int correctRowValue(int rowValue) {
        int rowCount = this.getRowCount() - 1;
        if (rowValue < 0) {
            return 0;
        }
        if (rowValue > rowCount) {
            return rowCount;
        }
        return rowValue;
    }

    @Reflected
    private void showModelMap() {
        if (this.modelMap == null) {
            return;
        }
        for (String columnName : this.modelMap.keySet()) {
            BeanModelProperty bmp = this.modelMap.get(columnName);
            System.out.printf("BeanTableModel.showModelMap():  Column Name: %s\n\t%s\n", columnName, bmp.toString());
        }
        new AsynchMethodInvoker((Object)this, "showModelMap", 1000);
    }
}

