/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.BeanModelProperty;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Null;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DynamicBeanTableModel
implements TableModel {
    private ArrayList<DynamicBean> model;
    private HashMap<String, BeanModelProperty> modelMap;
    private boolean modelMapDefined;
    private ArrayList<TableModelListener> tableModelListeners = new ArrayList();
    private Index<Integer, Integer> editableCells;
    private boolean isEditable;
    private String[] editableColumnNames;

    public DynamicBeanTableModel() {
        this.model = new ArrayList();
        this.modelMap = new HashMap();
    }

    private void setupModelMap(DynamicBean sample) {
        ArrayList<String> fields = new ArrayList<String>(sample.getPropertyNames());
        Collections.sort(fields);
        this.defineModelMap(sample, fields);
        if (CollectionUtility.isEmpty(this.editableCells) && !ArrayUtility.isEmpty(this.editableColumnNames)) {
            this.setEditableColumns(this.editableColumnNames);
        }
    }

    private void defineModelMap(DynamicBean sample, ArrayList<String> fields) {
        if (this.modelMapDefined) {
            return;
        }
        this.modelMapDefined = true;
        Class valueType = null;
        int i = 0;
        i = 0;
        while (i < fields.size()) {
            String fieldName = fields.get(i);
            try {
                Object value = sample.getProperty(fieldName);
                valueType = value == null ? Null.class : value.getClass();
            }
            catch (Exception value) {
                // empty catch block
            }
            BeanModelProperty bmp = this.modelMap.get(fieldName);
            if (bmp == null) {
                bmp = new BeanModelProperty(i, valueType, fieldName);
                this.modelMap.put(fieldName, bmp);
            } else {
                int columnNumber = bmp.getColumnNumber();
                Class<?> columnType = bmp.getColumnClass();
                String columnName = bmp.getColumnName();
                String displayExpression = bmp.getDisplayExpression();
                if (columnNumber == -1) {
                    bmp.setColumnNumber(i);
                }
                if (columnType == null) {
                    bmp.setColumnClass(valueType);
                }
                if (columnName == null) {
                    bmp.setColumnName(fieldName);
                }
                if (displayExpression == null) {
                    bmp.setDisplayExpression(fieldName);
                }
            }
            ++i;
        }
        ArrayList<BeanModelProperty> bmps = new ArrayList<BeanModelProperty>(this.modelMap.values());
        for (BeanModelProperty bmp : bmps) {
            if (bmp.getColumnNumber() == -1) {
                bmp.setColumnNumber(i++);
            }
            if (bmp.getColumnClass() != null || bmp.getBeanPropertyName().equals(bmp.getDisplayExpression())) continue;
            Object propertyValue = sample.getProperty(bmp.getBeanPropertyName());
            Object value = BeanService.getPropertyValue(propertyValue, bmp.getDisplayExpression());
            bmp.setColumnClass(value.getClass());
        }
        i = 0;
        Collections.sort(bmps);
        for (BeanModelProperty bmp : bmps) {
            int columnNumber = bmp.getColumnNumber();
            if (columnNumber >= Integer.MAX_VALUE) continue;
            bmp.setColumnNumber(i++);
        }
        ExtendedTableModelEvent evt = new ExtendedTableModelEvent(this, -1);
        for (TableModelListener listener : this.tableModelListeners) {
            listener.tableChanged(evt);
        }
    }

    public void addComputedExpression(String columnName, String expression) {
        BeanModelProperty bmp = this.modelMap.get(columnName);
        if (bmp != null) {
            bmp.setDisplayExpression(expression);
            bmp.setComputed(true);
        } else {
            int columnNumber = this.modelMap.size() - 1;
            if (this.modelMapDefined) {
                for (BeanModelProperty bmp2 : this.modelMap.values()) {
                    int bmpCN = bmp2.getColumnNumber();
                    if (bmpCN <= columnNumber) continue;
                    columnNumber = bmpCN;
                }
            }
            ++columnNumber;
            Class<?> columnClass = null;
            if (this.model.size() > 0) {
                Object expressionValue;
                DynamicBean base = this.model.get(0);
                Object propertyValue = base.getProperty(columnName);
                Object object = expressionValue = propertyValue == null ? null : (Object)BeanService.getPropertyValue(propertyValue, expression);
                if (expressionValue != null) {
                    columnClass = expressionValue.getClass();
                }
            }
            bmp = new BeanModelProperty(columnNumber, columnClass, columnName);
            bmp.setDisplayExpression(expression);
            bmp.setComputed(true);
            this.modelMap.put(columnName, bmp);
        }
    }

    public boolean isComputedExpression(int column) {
        for (String columnName : this.modelMap.keySet()) {
            BeanModelProperty bmp = this.modelMap.get(columnName);
            int columnNumber = bmp.getColumnNumber();
            if (columnNumber != column) continue;
            return true;
        }
        return false;
    }

    public String getComputedExpression(int column) {
        for (String columnName : this.modelMap.keySet()) {
            BeanModelProperty bmp = this.modelMap.get(columnName);
            int columnNumber = bmp.getColumnNumber();
            if (columnNumber != column) continue;
            return bmp.getDisplayExpression();
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.modelMap.values().size();
    }

    @Override
    public int getRowCount() {
        return this.model.size();
    }

    public void setEditable() {
        this.isEditable = true;
    }

    public void setEditableColumns(Collection<String> columnNames) {
        String[] editableColumnNames = columnNames.toArray(new String[0]);
        this.setEditableColumns(editableColumnNames);
    }

    public void setEditableColumns(String ... columnNames) {
        if (this.modelMap.size() == 0) {
            this.editableColumnNames = columnNames;
            return;
        }
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>(columnNames.length);
        Object object = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = object[n2];
            BeanModelProperty bmp = this.modelMap.get(columnName);
            if (bmp != null) {
                columnNumbers.add(bmp.getColumnNumber());
            }
            ++n2;
        }
        int[] editableColumns = new int[columnNumbers.size()];
        int i = 0;
        object = columnNumbers.iterator();
        while (object.hasNext()) {
            int columnNumber = (Integer)object.next();
            editableColumns[i++] = columnNumber;
        }
        this.setEditableColumns(editableColumns);
    }

    public void setEditableColumns(int ... columns) {
        this.isEditable = false;
        if (this.editableCells != null) {
            this.editableCells.clear();
        }
        int i = 0;
        while (i < columns.length) {
            this.setCellEditable(-1, columns[i]);
            ++i;
        }
    }

    public void setCellEditable(int row, int column) {
        this.setCellEditable(row, column, true);
    }

    public void setCellEditable(int row, int column, boolean editable) {
        if (!editable && this.editableCells == null) {
            return;
        }
        if (editable && this.editableCells == null) {
            this.editableCells = new Index();
        }
        if (editable) {
            this.editableCells.put((Integer)row, column);
        } else {
            Integer cValue = this.editableCells.remove((Integer)row, (Integer)column);
            if (cValue == null && (cValue = this.editableCells.remove((Integer)-1, (Integer)column)) != null) {
                int rowCount = this.getRowCount();
                int r = 0;
                while (r < rowCount) {
                    if (r != row) {
                        this.editableCells.put((Integer)row, column);
                    }
                    ++r;
                }
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.isEditable) {
            return true;
        }
        if (this.editableCells == null) {
            return false;
        }
        ArrayList editableColumns = (ArrayList)this.editableCells.get(row);
        if (editableColumns == null && (editableColumns = (ArrayList)this.editableCells.get(-1)) == null) {
            return false;
        }
        Iterator iterator = editableColumns.iterator();
        while (iterator.hasNext()) {
            int col = (Integer)iterator.next();
            if (col != column) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        BeanModelProperty property = this.getBeanModelProperty(column);
        if (property == null) {
            return String.class;
        }
        Class<?> type = property.getColumnClass();
        if (type == null) {
            if (this.model.size() > 0) {
                Object expressionValue;
                BeanModelProperty bmp;
                DynamicBean base = this.model.get(0);
                Object propertyValue = base.getProperty((bmp = this.getBeanModelProperty(column)).getBeanPropertyName());
                Object object = expressionValue = propertyValue == null ? null : (Object)BeanService.getPropertyValue(propertyValue, bmp.getDisplayExpression());
                if (expressionValue != null) {
                    type = expressionValue.getClass();
                    bmp.setColumnClass(type);
                }
            } else {
                type = BeanService.getPropertyType(type, property.getDisplayExpression());
            }
        }
        return property.getColumnClass();
    }

    public void addAll(Collection<DynamicBean> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        for (DynamicBean row : rows) {
            this.addRow(row);
        }
    }

    public void addRow(DynamicBean bean) {
        if (CollectionUtility.isEmpty(this.model)) {
            this.setupModelMap(bean);
        }
        this.model.add(bean);
        this.handleNewRow();
    }

    public void insertRow(DynamicBean bean, int beforeRow) {
        if (CollectionUtility.isEmpty(this.model)) {
            this.setupModelMap(bean);
        }
        this.model.add(beforeRow, bean);
        this.handleNewRow();
    }

    private void handleNewRow() {
        int firstRow = this.model.size() - 1;
        if (firstRow < 0) {
            firstRow = 0;
        }
        int lastRow = firstRow;
        this.fireTableModelEvent(firstRow, lastRow, 0, true, false, null, this.model.get(firstRow));
    }

    public void deleteRow(int row) {
        DynamicBean oldRow = this.model.get(row);
        this.model.remove(row);
        this.fireTableModelEvent(row, row, 0, false, true, oldRow, null);
    }

    public void deleteAll(int[] rows) {
        if (ArrayUtility.isEmpty(rows)) {
            return;
        }
        int minRow = Integer.MAX_VALUE;
        int maxRow = -1;
        Arrays.sort(rows);
        int i = rows.length - 1;
        while (i >= 0) {
            if (rows[i] < minRow) {
                minRow = rows[i];
            }
            if (rows[i] > maxRow) {
                maxRow = rows[i];
            }
            this.model.remove(rows[i]);
            --i;
        }
        this.fireTableModelEvent(minRow, maxRow, 0, false, true, null, null);
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean clearColumnModel) {
        ArrayList<DynamicBean> oldModel = new ArrayList<DynamicBean>(this.model);
        int rowCount = this.model.size();
        this.model.clear();
        if (clearColumnModel) {
            this.modelMap.clear();
        }
        this.fireTableModelEvent(0, rowCount - 1, 0, false, true, oldModel, null);
    }

    public ArrayList<DynamicBean> getModelData() {
        return this.getModelData(true);
    }

    public ArrayList<DynamicBean> getModelData(boolean useClone) {
        if (useClone) {
            ArrayList<DynamicBean> clonedModel = new ArrayList<DynamicBean>(this.model.size());
            for (DynamicBean element : this.model) {
                try {
                    DynamicBean clonedElement = (DynamicBean)element.clone();
                    clonedModel.add(clonedElement);
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            return clonedModel;
        }
        return this.model;
    }

    public DynamicBean getValue(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            throw new IllegalArgumentException("The given row (" + row + ") is out of range.");
        }
        return this.model.get(row);
    }

    public ArrayList<DynamicBean> getValues(int[] rows) {
        ArrayList<DynamicBean> values = new ArrayList<DynamicBean>();
        if (!ArrayUtility.isEmpty(rows)) {
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                DynamicBean value = this.model.get(row);
                values.add(value);
                ++n2;
            }
        }
        return values;
    }

    @Override
    public Object getValueAt(int row, int column) {
        BeanModelProperty bmp;
        Object value;
        int columnCount;
        int rowCount;
        block12: {
            rowCount = this.getRowCount();
            columnCount = this.getColumnCount();
            if (rowCount == 0 || columnCount == 0) {
                System.err.printf(String.format("DynamicBeanTableModel.getValueAt(row=%d, column=%d): Trying to get value from illegal count of rows (%d) or columns (%d).\n", row, column, rowCount, columnCount), new Object[0]);
                return null;
            }
            if (row < 0 || row >= rowCount || column < 0 || column >= columnCount) {
                String message = String.format("The given row (%d) of %d rows or column (%d) of %d columns is out of range.", row, rowCount, column, columnCount);
                throw new IllegalArgumentException(message);
            }
            value = null;
            bmp = this.getBeanModelProperty(column);
            if (bmp != null) break block12;
            System.err.printf("DynamicBeanTableModel.getValueAt(row=%d, column=%d): BeanModelProperty not found in getBeanModelProperty(%d)\n", row, column, column);
            return "---ERROR---";
        }
        try {
            DynamicBean rowValue = this.model.get(row);
            if (rowValue != null) {
                String propertyName = bmp.getBeanPropertyName();
                String displayExpression = bmp.getDisplayExpression();
                Object propertyValue = rowValue.getProperty(propertyName);
                if (bmp.isComputed()) {
                    value = propertyValue == null ? null : (Object)BeanService.getPropertyValue(propertyValue, displayExpression);
                } else {
                    value = propertyValue;
                    if (value != null && !propertyName.equals(displayExpression)) {
                        try {
                            value = BeanService.getPropertyValue(propertyValue, displayExpression);
                        }
                        catch (Exception e) {
                            System.err.printf("DynamicBeanTableModel.getValueAt(row=%d, column=%d):  Error evaluating expression [%s] for property %s of %s.  Row Count=%d, Column Count=%d\n", row, column, displayExpression, propertyName, value.getClass().getName(), rowCount, columnCount);
                        }
                    }
                }
            } else {
                System.err.printf("DynamicBeanTableModel.getValueAt(row=%d, column=%d):  Row value is null.  Row Count=%d, Column Count=%d\n", row, column, rowCount, columnCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("The given row (" + row + ") or column (" + column + ") is out of range.");
        }
        try {
            DynamicBean rowValue = this.model.get(row);
            String propertyName = this.getPropertyName(column);
            Object oldValue = rowValue.getProperty(propertyName);
            if (BeanService.areEqual(oldValue, rowValue)) {
                return;
            }
            rowValue.setProperty(propertyName, value);
            this.fireTableModelEvent(row, row, column, false, false, oldValue, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getPropertyName(int column) throws NoSuchFieldException {
        if (column < 0 || column >= this.getColumnCount()) {
            throw new ArrayIndexOutOfBoundsException("The column " + column + " is out of range. It should be in the range 0 - " + this.getColumnCount());
        }
        BeanModelProperty property = this.getBeanModelProperty(column);
        String beanPropertyName = property.getBeanPropertyName();
        return beanPropertyName;
    }

    public int getColumnIndex(String columnName) {
        if (CollectionUtility.isEmpty(this.modelMap)) {
            return -1;
        }
        for (BeanModelProperty bmp : this.modelMap.values()) {
            if (!bmp.getColumnName().equals(columnName)) continue;
            return bmp.getColumnNumber();
        }
        return -1;
    }

    @Override
    public String getColumnName(int column) {
        String columnName = "";
        for (BeanModelProperty bmp : this.modelMap.values()) {
            if (bmp.getColumnNumber() != column) continue;
            columnName = bmp.getBeanPropertyName();
            break;
        }
        return columnName;
    }

    private BeanModelProperty getBeanModelProperty(int column) {
        if (this.model == null || this.model.size() == 0) {
            return null;
        }
        for (BeanModelProperty bmp : this.modelMap.values()) {
            if (bmp.getColumnNumber() != column) continue;
            return bmp;
        }
        return null;
    }

    public void sortModel(BeanComparator<DynamicBean> sorter) {
        Collections.sort(this.model, sorter);
        this.fireTableModelEvent(0, this.getRowCount(), 0, false, false, null, null);
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.tableModelListeners.add(listener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.tableModelListeners.remove(listener);
        }
    }

    private void fireTableModelEvent(int firstRow, int lastRow, int column, boolean isRowNew, boolean isRowDeleted, Object oldValue, Object newValue) {
        int rowAction;
        int n = isRowNew ? 1 : (rowAction = isRowDeleted ? -1 : 0);
        if (rowAction != 0) {
            column = -1;
        }
        if (rowAction != -1) {
            firstRow = this.correctRowValue(firstRow);
            lastRow = this.correctRowValue(lastRow);
        }
        if (lastRow < firstRow) {
            int tmp = lastRow;
            lastRow = firstRow;
            firstRow = tmp;
        }
        ExtendedTableModelEvent evt = new ExtendedTableModelEvent(this, firstRow, lastRow, column, rowAction);
        evt.setOldValue(oldValue);
        evt.setNewValue(newValue);
        for (TableModelListener listener : this.tableModelListeners) {
            try {
                listener.tableChanged(evt);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                System.err.printf("DynamicBeanTableModel.fireTableModelEvent(firstRow=%d, lastRow=%d, column=%d, isRowNew=%b, isRowDeleted=%b):  Model Size: %d\n", firstRow, lastRow, column, isRowNew, isRowDeleted, this.getRowCount());
            }
        }
    }

    private int correctRowValue(int rowValue) {
        int rowCount = this.getRowCount() - 1;
        if (rowValue < 0) {
            return 0;
        }
        if (rowValue > rowCount) {
            return rowCount;
        }
        return rowValue;
    }

    @Reflected
    public void showModelMap() {
        if (this.modelMap == null) {
            return;
        }
        for (String columnName : this.modelMap.keySet()) {
            BeanModelProperty bmp = this.modelMap.get(columnName);
            System.out.printf("DynamicBeanTableModel.showModelMap():  Column Name: %s\n\t%s\n", columnName, bmp.toString());
        }
    }

    public boolean containsRow(DynamicBean row) {
        for (DynamicBean r : this.model) {
            if (!row.equals(r)) continue;
            return true;
        }
        return false;
    }
}

