/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.table.AbstractTableCellEditor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class PasswordTableCellEditorRenderer
extends AbstractTableCellEditor
implements TableCellRenderer {
    private Class<?> passwordType;
    private boolean showPassword;
    private JMTextField openField;
    private JMPasswordField maskedField;
    private Color normalForeground;
    private Color normalBackground;

    public PasswordTableCellEditorRenderer(Class<?> passwordType) {
        this.passwordType = passwordType;
        this.openField = new JMTextField(20);
        this.maskedField = new JMPasswordField(20);
        this.normalForeground = UIManager.getColor("Table.selectionForeground");
        this.normalBackground = UIManager.getColor("Table.selectionBackground");
    }

    public boolean isShowPassword() {
        return this.showPassword;
    }

    public void setShowPassword(boolean showPassword) {
        this.showPassword = showPassword;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.passwordType == String.class) {
            return this.maskedField.getText();
        }
        return this.maskedField.getPassword();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.getComponent(value);
        c.setBackground(isSelected ? this.normalBackground : this.normalForeground);
        c.setForeground(isSelected ? this.normalForeground : this.normalBackground);
        return c;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.getComponent(value);
    }

    private Component getComponent(Object value) {
        String strValue = "";
        strValue = value == null ? "" : (value instanceof String ? (String)value : new String((char[])value));
        this.openField.setText(strValue);
        this.maskedField.setText(strValue);
        JTextField component = this.showPassword ? this.openField : this.maskedField;
        return component;
    }
}

