/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.swing.table.TableMap;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSortService
extends TableMap {
    private int[] indexes;
    private Vector<Integer> sortingColumns = new Vector();
    private boolean ascending = true;
    private int compares;

    public TableSortService(JTable table) {
        TableModel model = table.getModel();
        this.setModel(model);
        table.setModel(this);
        this.addMouseListenerToHeaderInTable(table);
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    private int compareRowsByColumn(int row1, int row2, int column) {
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        AnyObjectComparator anyComparator = new AnyObjectComparator();
        return anyComparator.compare(o1, o2);
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (Integer column : this.sortingColumns) {
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.indexes[row] = row;
            ++row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        super.tableChanged(e);
    }

    private void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            System.err.println("TableSortService.checkModel():  Sorter not informed of a change in model.");
        }
    }

    private void sort(Object sender) {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    private void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            int i = low;
            while (i < high) {
                to[i] = from[i];
                ++i;
            }
            return;
        }
        int i = low;
        while (i < high) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
            ++i;
        }
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    private void addMouseListenerToHeaderInTable(JTable table) {
        final TableSortService sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    sorter.sortByColumn(column, ascending);
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }
}

