/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text;

import com.jmorgan.util.Comparison;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public abstract class CharacterFilteringDocumentFilter
extends DocumentFilter {
    private char[] allowedChars;
    private boolean isCaseSensitive;

    public CharacterFilteringDocumentFilter() {
        this(new char[0]);
    }

    public CharacterFilteringDocumentFilter(char[] allowedChars) {
        this.setAllowedChars(allowedChars);
        this.isCaseSensitive = true;
    }

    public CharacterFilteringDocumentFilter(String allowedCharacters) {
        this(allowedCharacters.toCharArray());
    }

    public char[] getAllowedChars() {
        return this.allowedChars;
    }

    public void setAllowedChars(String allowedChars) {
        this.setAllowedChars(allowedChars.toCharArray());
    }

    public void setAllowedChars(char[] allowedChars) {
        this.allowedChars = allowedChars;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (!this.isStringAllowed(string)) {
            return;
        }
        super.insertString(fb, offset, string, attr);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (!this.isStringAllowed(text)) {
            return;
        }
        super.replace(fb, offset, length, text, attrs);
    }

    protected boolean isStringAllowed(String text) {
        char[] textChars;
        if (text == null) {
            return false;
        }
        char[] cArray = textChars = text.toCharArray();
        int n = textChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Comparison.isIn(c, this.allowedChars)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected String getNewString(String oldText, int offset, int length, String textToInsert) {
        String prefix = oldText.substring(0, offset);
        String suffix = oldText.substring(offset + length);
        String newText = prefix + textToInsert + suffix;
        return newText;
    }
}

