/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor;

import com.jmorgan.swing.text.editor.DefaultSyntaxKit;
import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.Token;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.CaretMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;

public class SyntaxTester
extends JFrame {
    private JButton jButtonLoadFile;
    private JComboBox jCmbLangs;
    private JEditorPane jEdtTest;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JLabel lblCaretPos;
    private JLabel lblToken;

    public SyntaxTester() {
        this.initComponents();
        this.jCmbLangs.setModel(new DefaultComboBoxModel<String>(DefaultSyntaxKit.getContentTypes()));
        this.jCmbLangs.setSelectedItem("text/java");
        new CaretMonitor(this.jEdtTest, this.lblCaretPos);
        try {
            this.loadFile("./target/generated-sources/jflex/com.jmorgan.swing.text.editor/lexers/ClojureLexer.java");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonLoadFile = new JButton();
        this.jPanel1 = new JPanel();
        this.lblCaretPos = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jEdtTest = new JEditorPane();
        this.lblToken = new JLabel();
        this.jCmbLangs = new JComboBox();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("resources/com.jmorgan.swing.text.editor/Bundle");
        this.setTitle(bundle.getString("SyntaxTester.title"));
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        this.jButtonLoadFile.setMnemonic('L');
        this.jButtonLoadFile.setText(bundle.getString("SyntaxTester.jButtonLoadFile.text"));
        this.jButtonLoadFile.setFocusable(false);
        this.jButtonLoadFile.setHorizontalTextPosition(0);
        this.jButtonLoadFile.setVerticalTextPosition(3);
        this.jButtonLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SyntaxTester.this.jButtonLoadFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonLoadFile);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.lblCaretPos.setHorizontalAlignment(11);
        this.lblCaretPos.setText(bundle.getString("SyntaxTester.lblCaretPos.text"));
        this.jEdtTest.setContentType(bundle.getString("SyntaxTester.jEdtTest.contentType"));
        this.jEdtTest.setFont(new Font("Monospaced", 0, 13));
        this.jEdtTest.setCaretColor(new Color(153, 204, 255));
        this.jEdtTest.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                SyntaxTester.this.jEdtTestCaretUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jEdtTest);
        this.lblToken.setFont(new Font("Courier New", 0, 12));
        this.lblToken.setText(bundle.getString("SyntaxTester.lblToken.text"));
        this.jCmbLangs.setMaximumRowCount(20);
        this.jCmbLangs.setFocusable(false);
        this.jCmbLangs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SyntaxTester.this.jCmbLangsItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 727, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 727, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jCmbLangs, -2, 135, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 473, Short.MAX_VALUE).addComponent(this.lblCaretPos, -2, 119, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblToken, -1, 243, Short.MAX_VALUE).addGap(484, 484, 484))).addGap(0, 0, 0))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 449, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1, -1, 406, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.lblToken, -2, 19, -2).addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCaretPos, -1, -1, Short.MAX_VALUE).addComponent(this.jCmbLangs, -2, -1, -2)).addGap(0, 0, 0))));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jEdtTestCaretUpdate(CaretEvent evt) {
        SyntaxDocument sDoc = ActionUtils.getSyntaxDocument(this.jEdtTest);
        if (sDoc != null) {
            Token t = sDoc.getTokenAt(evt.getDot());
            if (t != null) {
                CharSequence tData = t.getText(sDoc);
                if (t.length > 40) {
                    tData = tData.subSequence(0, 40);
                }
                this.lblToken.setText(t.toString() + ": " + String.valueOf(tData));
            } else {
                this.lblToken.setText(ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("NO_TOKEN_AT_CURSOR"));
            }
        }
    }

    private void jCmbLangsItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String lang = this.jCmbLangs.getSelectedItem().toString();
            String oldText = this.jEdtTest.getText();
            this.jEdtTest.setContentType(lang);
            this.jToolBar1.removeAll();
            EditorKit kit = this.jEdtTest.getEditorKit();
            if (kit instanceof DefaultSyntaxKit) {
                DefaultSyntaxKit defaultSyntaxKit = (DefaultSyntaxKit)kit;
                defaultSyntaxKit.addToolBarActions(this.jEdtTest, this.jToolBar1);
            }
            this.jToolBar1.add(this.jButtonLoadFile);
            this.jToolBar1.validate();
            try {
                Document doc = kit.createDefaultDocument();
                doc.insertString(0, oldText, null);
                this.jEdtTest.setDocument(doc);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.jEdtTest.requestFocusInWindow();
    }

    private void jButtonLoadFileActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this.loadFile(fc.getSelectedFile().getPath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void loadFile(String filename) throws IOException {
        Document doc = this.jEdtTest.getEditorKit().createDefaultDocument();
        String str = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
        try {
            doc.insertString(0, str, null);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex);
        }
        this.jEdtTest.setDocument(doc);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSyntaxKit.initKit();
                    new SyntaxTester().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(2);
                }
            }
        });
    }
}

