/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import com.jmorgan.swing.text.editor.util.Configuration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;

public abstract class AbstractUndoRedoAction
extends DefaultSyntaxAction {
    private JEditorPane editor;
    protected SyntaxDocument doc;
    private final String property;
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            AbstractUndoRedoAction.this.setEnabled(AbstractUndoRedoAction.this.updateState());
        }
    };
    private PropertyChangeListener docListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            AbstractUndoRedoAction.this.removeDocument();
            Object newDoc = e.getNewValue();
            if (newDoc instanceof SyntaxDocument) {
                AbstractUndoRedoAction.this.setDocument((SyntaxDocument)newDoc);
            }
        }
    };

    protected AbstractUndoRedoAction(String property, String key) {
        super(key);
        this.property = property;
    }

    protected abstract boolean updateState();

    private void removeDocument() {
        if (this.doc != null) {
            this.doc.removePropertyChangeListener(this.property, this.propListener);
            this.doc = null;
        }
    }

    private void setDocument(SyntaxDocument newDoc) {
        if (this.doc != null) {
            throw new IllegalStateException();
        }
        this.doc = newDoc;
        this.doc.addPropertyChangeListener(this.property, this.propListener);
        this.setEnabled(this.updateState());
    }

    @Override
    public void install(JEditorPane editor, Configuration config, String name) {
        super.install(editor, config, name);
        if (this.editor != null) {
            throw new IllegalStateException();
        }
        this.editor = editor;
        editor.addPropertyChangeListener("document", this.docListener);
    }

    @Override
    public void deinstall(JEditorPane editor) {
        super.deinstall(editor);
        if (this.editor != editor) {
            throw new IllegalStateException();
        }
        editor.removePropertyChangeListener("document", this.docListener);
        this.removeDocument();
        this.editor = null;
    }
}

