/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.DefaultSyntaxKit;
import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.Token;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;

public class IndentAction
extends DefaultSyntaxAction {
    private Pattern wordsPattern = Pattern.compile("\\w+");

    public IndentAction() {
        super("insert-tab");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        String selected = target.getSelectedText();
        EditorKit kit = ((JEditorPane)target).getEditorKit();
        Map<String, String> abbrvs = ((DefaultSyntaxKit)kit).getAbbreviations();
        if (selected == null) {
            Token abbrToken = sDoc.getWordAt(dot, this.wordsPattern);
            Integer tabStop = ActionUtils.getTabSize(target);
            int lineStart = sDoc.getParagraphElement(dot).getStartOffset();
            int column = dot - lineStart;
            int needed = tabStop - column % tabStop;
            if (abbrvs == null || abbrToken == null) {
                target.replaceSelection("                ".substring(0, needed));
            } else {
                String abbr = abbrToken.getString(sDoc);
                if (abbrvs.containsKey(abbr)) {
                    target.select(abbrToken.start, abbrToken.end());
                    abbr = abbrvs.get(abbr);
                    String[] abbrLines = abbr.split("\n");
                    if (abbrLines.length > 1) {
                        ActionUtils.insertLinesTemplate(target, abbrLines);
                    } else {
                        ActionUtils.insertSimpleTemplate(target, abbr);
                    }
                } else {
                    target.replaceSelection("                ".substring(0, needed));
                }
            }
        } else {
            String[] lines = ActionUtils.getSelectedLines(target);
            int start = target.getSelectionStart();
            StringBuilder sb = new StringBuilder();
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                sb.append(ActionUtils.getTab(target));
                sb.append(line);
                sb.append('\n');
                ++n2;
            }
            target.replaceSelection(sb.toString());
            target.select(start, start + sb.length());
        }
    }

    public void setWordRegex(String regex) {
        this.wordsPattern = Pattern.compile(regex);
    }

    public Pattern getWordRegex() {
        return this.wordsPattern;
    }
}

