/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.Token;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class JUnindentAction
extends DefaultSyntaxAction {
    public JUnindentAction() {
        super("JUNINDENT");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        int pos = target.getCaretPosition();
        int start = sDoc.getParagraphElement(pos).getStartOffset();
        String line = ActionUtils.getLine(target);
        if (ActionUtils.isEmptyOrBlanks(line)) {
            try {
                sDoc.insertString(pos, "}", null);
                Token t = sDoc.getPairFor(sDoc.getTokenAt(pos));
                if (t != null) {
                    String pairLine = ActionUtils.getLineAt(target, t.start);
                    String indent = ActionUtils.getIndent(pairLine);
                    sDoc.replace(start, line.length() + 1, indent + "}", null);
                }
            }
            catch (BadLocationException ble) {
                target.replaceSelection("}");
            }
        } else {
            target.replaceSelection("}");
        }
    }
}

