/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.JTextComponent;

public class PairAction
extends DefaultSyntaxAction {
    private static Map<String, String> PAIRS = new HashMap<String, String>(4);

    static {
        PAIRS.put("(", ")");
        PAIRS.put("[", "]");
        PAIRS.put("\"", "\"");
        PAIRS.put("'", "'");
    }

    public PairAction() {
        super("PAIR_ACTION");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        String left = e.getActionCommand();
        String right = PAIRS.get(left);
        String selected = target.getSelectedText();
        if (selected != null) {
            target.replaceSelection(left + selected + right);
        } else {
            target.replaceSelection(left + right);
            target.setCaretPosition(target.getCaretPosition() - right.length());
        }
    }
}

