/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;

public class ToggleCommentsAction
extends DefaultSyntaxAction {
    protected String lineCommentStart = "//";
    protected Pattern lineCommentPattern = null;

    public ToggleCommentsAction() {
        super("toggle-comment");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        Matcher m1;
        if (this.lineCommentPattern == null) {
            this.lineCommentPattern = Pattern.compile("(^\\s*)(" + this.lineCommentStart + "\\s?)(.*)");
        }
        String[] lines = ActionUtils.getSelectedLines(target);
        int start = target.getSelectionStart();
        StringBuilder toggled = new StringBuilder();
        boolean allComments = true;
        int i = 0;
        while (i < lines.length) {
            m1 = this.lineCommentPattern.matcher(lines[i]);
            if (!m1.find()) {
                allComments = false;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < lines.length) {
            if (allComments) {
                m1 = this.lineCommentPattern.matcher(lines[i]);
                m1.find();
                toggled.append(m1.replaceFirst("$1$3"));
            } else {
                toggled.append(this.lineCommentStart);
                toggled.append(' ');
                toggled.append(lines[i]);
            }
            toggled.append('\n');
            ++i;
        }
        target.replaceSelection(toggled.toString());
        target.select(start, start + toggled.length());
    }

    public void setLineComments(String value) {
        String v1 = value.replace("\"", "");
        this.lineCommentStart = v1.charAt(v1.length() - 1) == ' ' ? v1.substring(0, v1.length() - 1) : v1;
        this.lineCommentPattern = null;
    }
}

