/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions.gui;

import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.gui.EscapeListener;
import com.jmorgan.swing.text.editor.util.SwingUtils;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class GotoLineDialog
extends JDialog
implements EscapeListener {
    private static final String PROPERTY_KEY = "GOTOLINE_DIALOG";
    private final WeakReference<JTextComponent> text;
    private JButton jBtnOk;
    private JComboBox jCmbLineNumbers;

    private GotoLineDialog(JTextComponent text) {
        super(SwingUtilities.getWindowAncestor(text), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.text = new WeakReference<JTextComponent>(text);
        this.setLocationRelativeTo(text.getRootPane());
        this.getRootPane().setDefaultButton(this.jBtnOk);
        text.getDocument().putProperty(PROPERTY_KEY, this);
        SwingUtils.addEscapeListener(this);
    }

    private void initComponents() {
        this.jCmbLineNumbers = new JComboBox();
        this.jBtnOk = new JButton();
        this.setTitle("Goto Line");
        this.setModal(true);
        this.setName("");
        this.setResizable(false);
        this.jCmbLineNumbers.setEditable(true);
        this.jCmbLineNumbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GotoLineDialog.this.jCmbLineNumbersActionPerformed(evt);
            }
        });
        this.jBtnOk.setAction(this.jCmbLineNumbers.getAction());
        this.jBtnOk.setText("Go");
        this.jBtnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GotoLineDialog.this.jBtnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jCmbLineNumbers, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnOk).addContainerGap(28, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCmbLineNumbers, -2, -1, -2).addComponent(this.jBtnOk, -2, 26, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void setTextPos() {
        Object line = this.jCmbLineNumbers.getSelectedItem();
        if (line != null) {
            try {
                int lineNr = Integer.parseInt(line.toString());
                ActionUtils.insertIntoCombo(this.jCmbLineNumbers, line);
                ActionUtils.setCaretPosition((JTextComponent)this.text.get(), lineNr, 0);
                this.setVisible(false);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "Invalid Number: " + String.valueOf(line), "Number Error", 0);
            }
        }
    }

    private void jCmbLineNumbersActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("comboBoxEdited")) {
            this.setTextPos();
        }
    }

    private void jBtnOkActionPerformed(ActionEvent evt) {
        this.setTextPos();
    }

    public static void showForEditor(JTextComponent text) {
        GotoLineDialog dlg = null;
        dlg = text.getDocument().getProperty(PROPERTY_KEY) == null ? new GotoLineDialog(text) : (GotoLineDialog)text.getDocument().getProperty(PROPERTY_KEY);
        dlg.jCmbLineNumbers.requestFocusInWindow();
        dlg.setVisible(true);
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
    }
}

