/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions.gui;

import com.jmorgan.swing.text.editor.actions.gui.ConstructorCell;
import com.jmorgan.swing.text.editor.actions.gui.FieldCell;
import com.jmorgan.swing.text.editor.actions.gui.MethodCell;
import com.jmorgan.swing.text.editor.actions.gui.ReflectCompletionDialog;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

class MembersListRenderer
extends DefaultListCellRenderer {
    static final Color evensColor = new Color(0xEEFFEE);
    private ReflectCompletionDialog dlg;

    public MembersListRenderer(ReflectCompletionDialog dlg) {
        this.dlg = dlg;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color back;
        Color color = back = index % 2 == 1 ? list.getBackground() : evensColor;
        if (value instanceof Method) {
            Method method = (Method)value;
            return new MethodCell(list, isSelected, back, method, this.dlg.getTheClass());
        }
        if (value instanceof Field) {
            Field field = (Field)value;
            return new FieldCell(list, isSelected, back, field, this.dlg.getTheClass());
        }
        if (value instanceof Constructor) {
            Constructor cons = (Constructor)value;
            return new ConstructorCell(list, isSelected, back, cons, this.dlg.getTheClass());
        }
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        comp.setBackground(back);
        return comp;
    }
}

