/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions.gui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.DocumentSearchData;
import com.jmorgan.swing.text.editor.actions.gui.EscapeListener;
import com.jmorgan.swing.text.editor.components.Markers;
import com.jmorgan.swing.text.editor.util.SwingUtils;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class ReplaceDialog
extends JDialog
implements CaretListener,
EscapeListener {
    private static Markers.SimpleMarker SEARCH_MARKER = new Markers.SimpleMarker(Color.YELLOW.darker().darker());
    private static String artRoot;
    private final JTextComponent textComponent;
    private final DocumentSearchData dsd;
    private JMButton jBtnNext;
    private JMButton jBtnPrev;
    private JMButton jBtnReplace;
    private JMButton jBtnReplaceAll;
    private JCheckBox jChkIgnoreCase;
    private JCheckBox jChkRegex;
    private JCheckBox jChkWrap;
    private JComboBox jCmbFind;
    private JComboBox jCmbReplace;
    private JMLabel jLblFind;
    private JMLabel jLblReplace;
    private JToggleButton jTglHighlight;

    static {
        GUIApplication appManager = GUIApplication.getGUIApplication();
        artRoot = appManager == null ? "/resources/" : String.format("/%s", appManager.getArtRoot());
    }

    public ReplaceDialog(JTextComponent text, DocumentSearchData dsd) {
        super(SwingUtilities.getWindowAncestor(text), Dialog.ModalityType.MODELESS);
        this.initComponents();
        this.textComponent = text;
        this.dsd = dsd;
        this.textComponent.addCaretListener(this);
        this.setLocationRelativeTo(text.getRootPane());
        this.getRootPane().setDefaultButton(this.jBtnNext);
        SwingUtils.addEscapeListener(this);
        this.jBtnReplaceAll.setEnabled(text.isEditable() && text.isEnabled());
    }

    public void updateHighlights() {
        Markers.removeMarkers(this.textComponent, SEARCH_MARKER);
        if (this.jTglHighlight.isSelected()) {
            Markers.markAll(this.textComponent, this.dsd.getPattern(), SEARCH_MARKER);
        }
    }

    private void showRegexpError(PatternSyntaxException ex) throws HeadlessException {
        JOptionPane.showMessageDialog(this, "Regexp error: " + ex.getMessage(), "Regular Expression Error", 0);
        this.jCmbFind.requestFocus();
    }

    private void updateFinder() {
        String regex = (String)this.jCmbFind.getSelectedItem();
        try {
            this.dsd.setPattern(regex, this.jChkRegex.isSelected(), this.jChkIgnoreCase.isSelected());
            ActionUtils.insertIntoCombo(this.jCmbFind, regex);
        }
        catch (PatternSyntaxException e) {
            this.showRegexpError(e);
        }
    }

    private void initComponents() {
        this.jLblFind = new JMLabel("&Find");
        this.jBtnNext = new JMButton("&Next", new ImageIcon(GUIApplication.getMenuResource(artRoot, "Next.png")));
        this.jBtnPrev = new JMButton("&Previous", new ImageIcon(GUIApplication.getMenuResource(artRoot, "Previous.png")));
        this.jBtnReplaceAll = new JMButton("Replace &All");
        this.jChkWrap = new JCheckBox();
        this.jChkRegex = new JCheckBox();
        this.jChkIgnoreCase = new JCheckBox();
        this.jLblReplace = new JMLabel("&Replace");
        this.jTglHighlight = new JToggleButton();
        this.jCmbReplace = new JComboBox();
        this.jCmbFind = new JComboBox();
        this.jBtnReplace = new JMButton("Replace", new ImageIcon(GUIApplication.getMenuResource(artRoot, "FindAndReplace.png")));
        this.setTitle("Find & Replace");
        this.setName("");
        this.setResizable(false);
        this.jLblFind.setLabelFor(this.jCmbFind);
        new ActionEventInvoker(this.jBtnNext, this, "findNext");
        new ActionEventInvoker(this.jBtnPrev, this, "findPrevious");
        new ActionEventInvoker(this.jBtnReplaceAll, this, "findReplaceAll");
        this.jChkWrap.setMnemonic('W');
        this.jChkWrap.setText("Wrap Around");
        this.jChkWrap.setToolTipText("Wrap to beginning when end is reached");
        this.jChkRegex.setMnemonic('R');
        this.jChkRegex.setText("Regular Expression");
        this.jChkIgnoreCase.setMnemonic('I');
        this.jChkIgnoreCase.setText("Ignore Case");
        this.jLblReplace.setLabelFor(this.jCmbReplace);
        this.jTglHighlight.setIcon(new ImageIcon(GUIApplication.getMenuResource(artRoot, "Highlight.png")));
        this.jTglHighlight.setText("Highlight");
        this.jTglHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReplaceDialog.this.jTglHighlightActionPerformed(evt);
            }
        });
        this.jCmbReplace.setEditable(true);
        this.jCmbFind.setEditable(true);
        new ActionEventInvoker(this.jBtnReplace, this, "findReplace");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLblFind).addComponent(this.jLblReplace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCmbFind, 0, 289, Short.MAX_VALUE).addComponent(this.jCmbReplace, GroupLayout.Alignment.TRAILING, 0, 289, Short.MAX_VALUE).addComponent(this.jChkRegex, -1, 289, Short.MAX_VALUE).addComponent(this.jChkWrap, -1, 289, Short.MAX_VALUE).addComponent(this.jChkIgnoreCase, -1, 289, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBtnReplace, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jBtnNext, -1, -1, Short.MAX_VALUE).addComponent(this.jBtnPrev, -1, -1, Short.MAX_VALUE).addComponent(this.jTglHighlight, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jBtnReplaceAll, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblFind).addComponent(this.jCmbFind, -2, -1, -2).addComponent(this.jBtnNext)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnPrev).addComponent(this.jCmbReplace, -2, -1, -2).addComponent(this.jLblReplace)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnReplace).addComponent(this.jChkWrap, -2, 23, -2)).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkRegex).addComponent(this.jBtnReplaceAll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkIgnoreCase).addComponent(this.jTglHighlight)).addContainerGap()));
        this.pack();
    }

    @Reflected
    private void findNext() {
        try {
            this.updateFinder();
            if (!this.dsd.doFindNext(this.textComponent)) {
                this.dsd.msgNotFound(this.textComponent);
            }
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    @Reflected
    private void findReplaceAll() {
        try {
            this.updateFinder();
            String replacement = (String)this.jCmbReplace.getSelectedItem();
            if (replacement == null) {
                replacement = "";
            }
            if (!this.jChkRegex.isSelected()) {
                replacement = Matcher.quoteReplacement(replacement);
            }
            ActionUtils.insertIntoCombo(this.jCmbReplace, replacement);
            this.jTglHighlight.setSelected(false);
            this.dsd.doReplaceAll(this.textComponent, replacement);
            this.textComponent.requestFocusInWindow();
        }
        catch (PatternSyntaxException ex) {
            this.showRegexpError(ex);
        }
    }

    private void jTglHighlightActionPerformed(ActionEvent evt) {
        this.updateFinder();
        this.updateHighlights();
    }

    @Reflected
    private void findPrevious() {
        this.updateFinder();
        this.dsd.doFindPrev(this.textComponent);
    }

    @Reflected
    private void findReplace() {
        this.jTglHighlight.setSelected(false);
        String replacement = this.jCmbReplace.getSelectedItem() == null ? "" : this.jCmbReplace.getSelectedItem().toString();
        this.dsd.doReplace(this.textComponent, replacement);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.updateHighlights();
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
    }
}

