/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.event.MouseEventInvoker;
import com.jmorgan.swing.util.ContainerService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.StringUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public final class ComponentService {
    private static final int ICON_SIZE = 16;
    private static final int ICON_GAP = 5;
    private static final int ICON_RIGHT_OFFSET = 21;
    private static ComponentService eventHandler;

    private ComponentService() {
    }

    public static final Frame getFrame(Component c) {
        Container p = c.getParent();
        while (!(p instanceof Frame) && p != null) {
            p = p.getParent();
        }
        return (Frame)p;
    }

    public static final Window getParentWindow(Component c) {
        Container p = c.getParent();
        while (!(p instanceof Window) && p != null) {
            p = p.getParent();
        }
        return (Window)p;
    }

    public static final Point getLocationInParent(Component component, Container parent) {
        if (component == null || parent == null) {
            return null;
        }
        Point location = new Point(component.getLocation());
        Container p = null;
        do {
            p = component.getParent();
            Point parentLocation = component.getLocation();
            location.x += parentLocation.x;
            location.y += parentLocation.y;
        } while (p != null && p != parent);
        return location;
    }

    public static final Point getLocationInRootPane(Component component) {
        if (component == null) {
            return null;
        }
        Point location = new Point(component.getLocation());
        Container p = component.getParent();
        while (!(p instanceof JRootPane) && p != null) {
            Point loc = p.getLocation();
            location.x += loc.x;
            location.y += loc.y;
            p = p.getParent();
        }
        return location;
    }

    public static final Component getGlassPane(Component component) {
        Container c = component.getParent();
        while (!(c instanceof RootPaneContainer)) {
            c = c.getParent();
        }
        RootPaneContainer rpc = (RootPaneContainer)((Object)c);
        return rpc.getGlassPane();
    }

    public static final boolean isContainedBy(Component component, Container container) throws NullPointerException {
        if (component == null || container == null) {
            throw new NullPointerException("The component nor the container can be null in ComponentServicse.isContainedBy(Component, Container)");
        }
        Container parent = component.getParent();
        do {
            if (parent != container) continue;
            return true;
        } while ((parent = parent.getParent()) != null);
        return false;
    }

    public static void addClearIcon(JComponent parent, String helpText) {
        PictureControl clearIcon = (PictureControl)ContainerService.findComponentByName(parent, "clearIcon");
        if (clearIcon != null) {
            return;
        }
        clearIcon = ComponentService.createIcon(parent, "Cancel.png", helpText);
        clearIcon.setName("clearIcon");
        new MouseEventInvoker((Object)clearIcon, 16, parent, "setText", "");
        ComponentService.positionOverlayIcons((JMTextField)parent);
    }

    public static void addHelpIcon(JComponent component, String helpText) {
        PictureControl helpIcon = (PictureControl)ContainerService.findComponentByName(component, "helpIcon");
        if (helpIcon != null) {
            return;
        }
        helpIcon = ComponentService.createIcon(component, "HelpTopics.png", helpText);
        helpIcon.setName("helpIcon");
        new MouseEventInvoker((Object)helpIcon, 16, eventHandler, "showHelpInPopup", component);
        ComponentService.positionOverlayIcons(component);
    }

    private static PictureControl createIcon(JComponent component, String imageName, String helpText) {
        LayoutManager layoutManager;
        if (eventHandler == null) {
            eventHandler = new ComponentService();
        }
        String artRootBaseDirectory = GUIServices.getArtRootBaseDirectory();
        ImageIcon icon = new ImageIcon(GUIApplication.getMenuResource(artRootBaseDirectory, imageName));
        PictureControl imageIcon = new PictureControl(icon.getImage());
        Dimension size = imageIcon.getSize();
        imageIcon.setPreferredSize(size);
        imageIcon.setCursor(new Cursor(12));
        if (StringUtility.isNotEmpty(helpText)) {
            imageIcon.setToolTipText(helpText);
        }
        if ((layoutManager = component.getLayout()) instanceof FlowLayout) {
            component.add(imageIcon);
        } else if (layoutManager instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layoutManager;
            Component eastComponent = borderLayout.getLayoutComponent("East");
            if (eastComponent == null) {
                component.add((Component)imageIcon, "East");
            } else {
                ((Container)eastComponent).add(imageIcon);
            }
        } else {
            component.add((Component)imageIcon, 0);
            component.setComponentZOrder(imageIcon, 0);
        }
        new ComponentEventInvoker(component, 14, (Object)eventHandler, "positionOverlayIcons", component);
        return imageIcon;
    }

    @Reflected
    private static void showHelpInPopup(JComponent component) {
        PictureControl helpIcon = (PictureControl)ContainerService.findComponentByName(component, "helpIcon");
        if (helpIcon == null) {
            return;
        }
        String toolTip = helpIcon.getToolTipText();
        Window parentWindow = ComponentService.getParentWindow(component);
        if (parentWindow != null) {
            if (parentWindow instanceof JFrame) {
                JFrame jFrame = (JFrame)parentWindow;
                new JMMessageBox(jFrame, "Help", toolTip);
            } else if (parentWindow instanceof JDialog) {
                JDialog jDialog = (JDialog)parentWindow;
                new JMMessageBox(jDialog, "Help", toolTip);
            }
        }
    }

    private static void positionOverlayIcons(JComponent component) {
        if (component instanceof JMTextField) {
            JMTextField textField = (JMTextField)component;
            ComponentService.positionOverlayIcons(textField);
        }
    }

    private static void positionOverlayIcons(JMTextField component) {
        Border textFieldBorder = UIManager.getBorder("TextField.border");
        component.setBorder(textFieldBorder);
        PictureControl clearIcon = (PictureControl)ContainerService.findComponentByName(component, "clearIcon");
        PictureControl helpIcon = (PictureControl)ContainerService.findComponentByName(component, "helpIcon");
        if (clearIcon == null && helpIcon == null) {
            return;
        }
        ArrayList<PictureControl> overlayIcons = new ArrayList<PictureControl>();
        if (helpIcon != null) {
            overlayIcons.add(helpIcon);
        }
        if (clearIcon != null) {
            overlayIcons.add(clearIcon);
        }
        Rectangle thisPosition = component.getBounds();
        int iconX = thisPosition.width - 21;
        int iconY = (int)((double)(thisPosition.height - 16) / 2.0) + 1;
        for (PictureControl overlayIcon : overlayIcons) {
            Rectangle iconPosition = new Rectangle(iconX, iconY, 16, 16);
            overlayIcon.setBounds(iconPosition);
            iconX -= 21;
        }
        int rightBorderAdjustment = 21 * overlayIcons.size() + 5;
        Border outerBorder = BorderFactory.createEmptyBorder(0, 0, 0, rightBorderAdjustment);
        CompoundBorder tempBorder = new CompoundBorder(outerBorder, component.getBorder());
        component.setBorder(tempBorder);
        overlayIcons.clear();
        overlayIcons = null;
    }

    public static void removeClearIcon(JComponent component) {
        PictureControl clearIcon = (PictureControl)ContainerService.findComponentByName(component, "clearIcon");
        if (clearIcon == null) {
            return;
        }
        ComponentService.removeIcon(component, clearIcon);
    }

    public static void removeHelpIcon(JComponent component) {
        PictureControl helpIcon = (PictureControl)ContainerService.findComponentByName(component, "helpIcon");
        if (helpIcon == null) {
            return;
        }
        ComponentService.removeIcon(component, helpIcon);
    }

    private static void removeIcon(JComponent component, PictureControl icon) {
        if (icon != null) {
            component.remove(icon);
            ComponentService.positionOverlayIcons((JMTextField)component);
        }
    }
}

