/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;

public final class ContainerService {
    private ContainerService() {
    }

    public static void setEnabled(Container container, boolean enabled) {
        Component[] components;
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof Container) {
                ContainerService.setEnabled((Container)component, enabled);
            }
            component.setEnabled(enabled);
            ++n2;
        }
        container.setEnabled(false);
    }

    public static void pack(Container container) {
        Dimension optimalSize = ContainerService.getOptimalContainerSize(container);
        container.setPreferredSize(optimalSize);
        container.setSize(optimalSize);
        Window parentWindow = GUIServices.getParentWindow(container);
        if (parentWindow != null) {
            parentWindow.invalidate();
            parentWindow.repaint();
        }
    }

    public static Dimension getOptimalContainerSize(Container container) {
        Component[] components;
        Dimension optimalSize = new Dimension(0, 0);
        Insets borderInsets = null;
        Border border = container instanceof JPanel ? ((JPanel)container).getBorder() : null;
        borderInsets = border == null ? InsetsFactory.createFixedInsets(0) : border.getBorderInsets(container);
        LayoutManager layout = container.getLayout();
        if (layout != null) {
            layout.layoutContainer(container);
        }
        optimalSize.width = borderInsets.left + borderInsets.right;
        optimalSize.height = borderInsets.top + borderInsets.bottom;
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            Rectangle rect = c.getBounds();
            Dimension cSize = null;
            cSize = c instanceof Container ? ContainerService.getOptimalContainerSize((Container)c) : c.getSize();
            if (cSize.width < rect.width) {
                cSize.width = rect.width;
            }
            if (cSize.height < rect.height) {
                cSize.height = rect.height;
            }
            int right = rect.x + cSize.width;
            int bottom = rect.y + cSize.height;
            if (right > optimalSize.width) {
                optimalSize.width = right;
            }
            if (bottom > optimalSize.height) {
                optimalSize.height = bottom;
            }
            ++n2;
        }
        return optimalSize;
    }

    public static Component findComponentByName(Container container, String componentName) {
        Component[] components;
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c;
            Component item = componentArray[n2];
            String itemName = item.getName();
            if (itemName != null && itemName.equalsIgnoreCase(componentName)) {
                return item;
            }
            if (item instanceof Container && (c = ContainerService.findComponentByName((Container)item, componentName)) != null) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isContainedBy(Container container, Component component) {
        Component[] components;
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component item = componentArray[n2];
            if (item == component) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(Container container, Component component) {
        Component[] components;
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component item = componentArray[n2];
            if (item == component) {
                return true;
            }
            if (item instanceof Container) {
                return ContainerService.contains((Container)item, component);
            }
            ++n2;
        }
        return false;
    }

    public static <T extends Component> List<T> findComponentsByType(Container container, Class<T> type) throws IllegalArgumentException {
        Component[] components;
        if (container == null) {
            throw new IllegalArgumentException("The container parameter of ContainerService.findComponentsByType(Container container, Class type) cannot be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type parameter of ContainerService.findComponentsByType(Container container, Class type) cannot be null.");
        }
        ArrayList<Component> matchingComponents = new ArrayList<Component>();
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component.getClass().isAssignableFrom(type)) {
                matchingComponents.add(component);
            }
            ++n2;
        }
        return matchingComponents;
    }

    public static int getWidestComponent(Component[] comp) {
        int maxWidth = 0;
        int i = 0;
        while (i < comp.length) {
            int componentWidth;
            if (comp[i] != null && comp[i].isVisible() && (componentWidth = comp[i].getPreferredSize().width) > maxWidth) {
                maxWidth = componentWidth;
            }
            ++i;
        }
        return maxWidth;
    }
}

