/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.beans.util.NumberToFloatConverter;
import com.jmorgan.beans.util.NumberToIntegerConverter;
import com.jmorgan.beans.util.NumberToLongConverter;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.customizer.BooleanCustomizer;
import com.jmorgan.swing.customizer.BorderCustomizer;
import com.jmorgan.swing.customizer.ColorCustomizer;
import com.jmorgan.swing.customizer.ComponentOrientationCustomizer;
import com.jmorgan.swing.customizer.CursorCustomizer;
import com.jmorgan.swing.customizer.DimensionCustomizer;
import com.jmorgan.swing.customizer.FontCustomizer;
import com.jmorgan.swing.customizer.IconCustomizer;
import com.jmorgan.swing.customizer.ImageCustomizer;
import com.jmorgan.swing.customizer.InsetsCustomizer;
import com.jmorgan.swing.customizer.NumberCustomizer;
import com.jmorgan.swing.customizer.PointCustomizer;
import com.jmorgan.swing.customizer.RectangleCustomizer;
import com.jmorgan.swing.customizer.StringCustomizer;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.border.Border;

public class CustomizerFactory {
    private final HashMap<String, AbstractCustomizer<?, ?>> panels = new HashMap();

    public final AbstractCustomizer<?, ?> getCustomizer(Object propertyValue, String propertyName) {
        AbstractCustomizer customizer = this.panels.get(propertyName);
        if (customizer == null) {
            System.out.println("CustomizerFactory.getCustomizer(Object propertyValue, String propertyName): Creating new panel");
            if (propertyValue instanceof Boolean) {
                customizer = new BooleanCustomizer();
            } else if (propertyValue instanceof Integer) {
                NumberCustomizer nc = new NumberCustomizer();
                nc.setDataTypeConverter(new NumberToIntegerConverter(0));
                nc.setNumberFormat("#,##0;-#,##0");
                customizer = nc;
            } else if (propertyValue instanceof Long) {
                NumberCustomizer nc = new NumberCustomizer();
                nc.setDataTypeConverter(new NumberToLongConverter(0L));
                nc.setNumberFormat("#,##0;-#,##0");
                customizer = nc;
            } else if (propertyValue instanceof Float) {
                NumberCustomizer nc = new NumberCustomizer();
                nc.setDataTypeConverter(new NumberToFloatConverter(Float.valueOf(0.0f)));
                customizer = nc;
            } else if (propertyValue instanceof Double) {
                customizer = new NumberCustomizer();
            } else if (propertyValue instanceof Insets) {
                customizer = new InsetsCustomizer();
            } else if (propertyValue instanceof Font) {
                customizer = new FontCustomizer();
            } else if (propertyValue instanceof Color) {
                customizer = new ColorCustomizer();
            } else if (propertyValue instanceof Point) {
                customizer = new PointCustomizer();
            } else if (propertyValue instanceof Dimension) {
                customizer = new DimensionCustomizer();
            } else if (propertyValue instanceof Rectangle) {
                customizer = new RectangleCustomizer();
            } else if (propertyValue instanceof ComponentOrientation) {
                customizer = new ComponentOrientationCustomizer();
            } else if (propertyValue instanceof Icon) {
                customizer = new IconCustomizer();
            } else if (propertyValue instanceof Image) {
                customizer = new ImageCustomizer();
            } else if (propertyValue instanceof Cursor) {
                customizer = new CursorCustomizer();
            } else if (propertyValue instanceof Border) {
                customizer = new BorderCustomizer();
            } else {
                propertyValue = propertyValue.toString();
                customizer = new StringCustomizer();
            }
            ((AbstractCustomizer)customizer).setPropertyName(propertyName);
            ((AbstractCustomizer)customizer).setObject(propertyValue);
            this.panels.put(propertyName, customizer);
        }
        System.out.println("CustomizerFactory.getCustomizer(Object propertyValue, String propertyName): Panel Selected:\n" + customizer.getClass().getName());
        return customizer;
    }
}

