/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.menu.MenuConstants;
import com.jmorgan.swing.menu.ToolBarButton;
import com.jmorgan.swing.util.GUIServices;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class PropertiesEditorPane
extends JMPanel
implements ActionListener {
    private JMTable dataTable;
    private PropertiesTableModel tableModel;
    private Window parentWindow = null;
    private JMScrollPane scrollPane;

    public PropertiesEditorPane(String keyTitle, String valueTitle) {
        this.setLayout(new BorderLayout());
        this.tableModel = new PropertiesTableModel();
        this.dataTable = new JMTable(this.tableModel);
        int[] widths = new int[]{500, 500};
        String[] names = new String[]{keyTitle, valueTitle};
        int i = 0;
        while (i < widths.length) {
            TableColumn col = this.dataTable.getColumnModel().getColumn(i);
            col.setPreferredWidth(widths[i]);
            col.setHeaderValue(names[i]);
            ++i;
        }
        this.scrollPane = new JMScrollPane(this.dataTable);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)new PropertiesToolBar(this), "East");
    }

    public PropertiesEditorPane(Properties properties, String keyTitle, String valueTitle) {
        this(keyTitle, valueTitle);
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            this.tableModel.addRow(new String[]{key, value});
        }
    }

    public Properties getProperties() {
        Properties p = new Properties();
        int rows = this.tableModel.getRowCount();
        int row = 0;
        while (row < rows) {
            String key = (String)this.tableModel.getValueAt(row, 0);
            String value = (String)this.tableModel.getValueAt(row, 1);
            p.setProperty(key, value);
            ++row;
        }
        return p;
    }

    @Override
    public final void actionPerformed(ActionEvent ae) {
        String value;
        String key;
        String msg;
        int option;
        if (this.parentWindow == null) {
            this.parentWindow = GUIServices.getParentWindow(this);
        }
        String actionCommand = ae.getActionCommand();
        int currentRow = this.dataTable.getSelectedRow();
        if (actionCommand.equals("add")) {
            this.tableModel.addRow(new String[]{"", ""});
        }
        if (actionCommand.equals("delete") && (option = JOptionPane.showConfirmDialog(this, msg = "Remove " + (key = (String)this.tableModel.getValueAt(currentRow, 0)) + " (" + (value = (String)this.tableModel.getValueAt(currentRow, 1)) + ") from this list?", "Confirm Property Deletion", 0)) == 0) {
            this.tableModel.removeRow(currentRow);
        }
    }

    private class PropertiesTableModel
    extends DefaultTableModel {
        PropertiesTableModel() {
            super(0, 2);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }
    }

    private class PropertiesToolBar
    extends JMPanel {
        PropertiesToolBar(ActionListener al) {
            this.setLayout(new VerticalFlowLayout(2, 1));
            Dimension dim = new Dimension(18, 18);
            ToolBarButton addTB = new ToolBarButton(MenuConstants.editAddProperties.getIcon());
            addTB.setActionCommand("add");
            addTB.addActionListener(al);
            addTB.setPreferredSize(dim);
            addTB.setToolTipText("Add a new Property");
            ToolBarButton deleteTB = new ToolBarButton(MenuConstants.editDeleteProperties.getIcon());
            deleteTB.setActionCommand("delete");
            deleteTB.addActionListener(al);
            deleteTB.setPreferredSize(dim);
            deleteTB.setToolTipText("Delete Property");
            this.add(addTB);
            this.add(deleteTB);
            this.setPreferredSize(new Dimension(32, 36));
        }
    }
}

