/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.menu.JMToolBar;
import com.jmorgan.swing.menu.MenuConstants;
import com.jmorgan.swing.menu.ToolBarButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;

public class TextViewPane
extends JMPanel {
    private JMTextArea textView;
    private ToolBarButton print = new ToolBarButton(MenuConstants.filePrintProperties.getIcon());

    protected TextViewPane() {
        super(new BorderLayout());
        JMToolBar toolBar = new JMToolBar(1);
        toolBar.add(this.print);
        this.add((Component)toolBar, "East");
    }

    public TextViewPane(String[] data) {
        this();
        this.viewData(data);
    }

    public TextViewPane(Collection<?> data) {
        this();
        this.viewData(data);
    }

    protected void viewData(Collection<?> data) {
        String[] textData = new String[data.size()];
        int index = 0;
        Iterator<?> i = data.iterator();
        while (i.hasNext()) {
            textData[index] = i.next().toString();
            ++index;
        }
        this.viewData(textData);
    }

    protected void viewData(String[] data) {
        StringBuilder buffer = new StringBuilder();
        int maxLineWidth = 0;
        int i = 0;
        while (i < data.length) {
            int len = data[i].length();
            if (len > maxLineWidth) {
                maxLineWidth = len;
            }
            buffer.append(data[i]);
            buffer.append('\n');
            ++i;
        }
        int numRows = data.length;
        if (numRows > 25) {
            numRows = 25;
        }
        if (maxLineWidth > 80) {
            maxLineWidth = 80;
        }
        this.textView = new JMTextArea(numRows, maxLineWidth);
        this.textView.setText(buffer.toString());
        JMScrollPane sp = new JMScrollPane(this.textView);
        this.add((Component)sp, "Center");
    }
}

