/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.beans.JMBean;
import com.jmorgan.swing.util.ComponentConnector;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.JComponent;

public class VisualComponentConnector
extends JMBean
implements MouseListener,
ContainerListener {
    private Container parent;
    private JComponent startComponent;
    private JComponent endComponent;
    private Cursor handCursor;
    private Cursor normalCursor;
    private Cursor illegalCursor;
    private boolean enabled = true;
    private Index<JComponent, Pair<JComponent, ComponentConnector>> connectors = new Index();

    public VisualComponentConnector(Container parent) {
        this.handCursor = new Cursor(12);
        this.normalCursor = new Cursor(0);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage("cross.png");
        Point hotSpot = new Point(8, 8);
        this.illegalCursor = toolkit.createCustomCursor(image, hotSpot, "Illegal");
        this.setParent(parent);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!this.enabled) {
            this.reset();
        }
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container parent) {
        Component component;
        int n;
        int n2;
        Component[] componentArray;
        Component[] components;
        if (this.parent != null) {
            this.parent.removeContainerListener(this);
            componentArray = components = this.parent.getComponents();
            n2 = components.length;
            n = 0;
            while (n < n2) {
                component = componentArray[n];
                component.removeMouseListener(this);
                ++n;
            }
            this.reset();
        }
        this.parent = parent;
        if (this.parent != null) {
            componentArray = components = this.parent.getComponents();
            n2 = components.length;
            n = 0;
            while (n < n2) {
                component = componentArray[n];
                component.addMouseListener(this);
                ++n;
            }
        }
        this.parent.addContainerListener(this);
    }

    public JComponent getStartComponent() {
        return this.startComponent;
    }

    public void setStartComponent(JComponent startComponent) {
        this.startComponent = startComponent;
    }

    public JComponent getEndComponent() {
        return this.endComponent;
    }

    public void setEndComponent(JComponent endComponent) {
        if (endComponent == this.startComponent) {
            return;
        }
        this.endComponent = endComponent;
        if (this.endComponent != null) {
            ComponentConnector connector = new ComponentConnector(this.startComponent, this.endComponent);
            this.parent.add(connector);
            this.connectors.put(this.startComponent, new Pair<JComponent, ComponentConnector>(this.endComponent, connector));
            this.connectors.put(this.endComponent, new Pair<JComponent, ComponentConnector>(this.startComponent, connector));
            this.reset();
            this.parent.repaint();
        }
    }

    private void reset() {
        this.startComponent = null;
        this.endComponent = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        Component component = e.getComponent();
        if (this.startComponent == null) {
            this.setStartComponent((JComponent)component);
            return;
        }
        if (this.endComponent == null) {
            this.setEndComponent((JComponent)component);
            return;
        }
        throw new IllegalStateException("Invalid state: Both start and end components are valid references.");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        Component component = e.getComponent();
        if (component == this.startComponent) {
            component.setCursor(this.illegalCursor);
        } else {
            component.setCursor(this.handCursor);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        Component component = e.getComponent();
        component.setCursor(this.normalCursor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component component = e.getComponent();
        component.addMouseListener(this);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Component component = e.getChild();
        component.removeMouseListener(this);
        this.removeConnectors((JComponent)component);
        if (component == this.startComponent || component == this.endComponent) {
            this.reset();
        }
        e.getContainer().repaint();
    }

    private void removeConnectors(JComponent component) {
        Collection<Pair<JComponent, ComponentConnector>> connections = this.connectors.get(component);
        if (connections == null) {
            return;
        }
        for (Pair<JComponent, ComponentConnector> connection : connections) {
            ComponentConnector connector = (ComponentConnector)connection.second;
            connector.getParent().remove(connector);
        }
        this.connectors.removeAll(component);
    }
}

