/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.text;

import com.jmorgan.text.Validator;

public class StringLengthValidator
implements Validator {
    private int minimumLength;
    private int maximumLength;

    public StringLengthValidator(int minimumLength, int maximumLength) {
        this.setMinimumLength(minimumLength);
        this.setMaximumLength(maximumLength);
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    @Override
    public boolean isCompatibleWith(Object value) {
        return value == null || value instanceof String;
    }

    @Override
    public boolean isValid(Object value) {
        int length = ((String)value).length();
        return length >= this.minimumLength && length <= this.maximumLength;
    }

    @Override
    public String getValidationInfo() {
        return String.format("The value must be between %d and %d characters in length", this.minimumLength, this.maximumLength);
    }
}

