/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.util.comparator.CollectionComparator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public final class ArrayUtility {
    public static final boolean SHIFT_LEFT = false;
    public static final boolean SHIFT_RIGHT = true;

    private ArrayUtility() {
    }

    public static int indexOf(byte element, byte[] array) {
        int i = 0;
        while (i < array.length) {
            if (element == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char element, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (element == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(short element, short[] array) {
        int i = 0;
        while (i < array.length) {
            if (element == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int element, int[] array) {
        int i = 0;
        while (i < array.length) {
            if (element == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(long element, long[] array) {
        int i = 0;
        while (i < array.length) {
            if (element == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(float element, float[] array) {
        int i = 0;
        while (i < array.length) {
            if (element == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(double element, double[] array) {
        int i = 0;
        while (i < array.length) {
            if (element == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(Object element, Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (element.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(byte[] subset, byte[] array) {
        return ArrayUtility.indexOf(subset, array, 0);
    }

    public static int indexOf(byte[] subset, byte[] array, int start) {
        if (ArrayUtility.isEmpty(subset)) {
            return -2;
        }
        if (array == null) {
            throw new NullPointerException("ArrayUtility.indexOf(byte[] subset, byte[] array, int start):  The array cannot be null.");
        }
        if (subset.length > array.length) {
            throw new IllegalArgumentException(String.format("ArrayUtility.indexOf(byte[] subset, byte[] array, int start):  The length of subset (%d) is greater than then length of array (%d).", subset.length, array.length));
        }
        if (start >= array.length) {
            throw new IndexOutOfBoundsException(String.format("ArrayUtility.indexOf(byte[] subset, byte[] array, int start):  The starting position %d is out of range for array length of %d.", start, array.length));
        }
        int SUBSET_LENGTH = subset.length - 1;
        byte START_BYTE = subset[0];
        byte END_BYTE = subset[SUBSET_LENGTH];
        int SUBSET_END = SUBSET_LENGTH - 1;
        int forwardIndex = 0;
        int reverseIndex = 0;
        int arrayIndexBeginning = 0;
        int arrayOffset = 0;
        int arrayIndex = start + SUBSET_LENGTH;
        while (arrayIndex < array.length) {
            arrayIndexBeginning = arrayIndex - SUBSET_LENGTH;
            if (array[arrayIndexBeginning] == START_BYTE && array[arrayIndex] == END_BYTE) {
                forwardIndex = 1;
                reverseIndex = SUBSET_END;
                arrayOffset = 1;
                while (forwardIndex < reverseIndex && array[arrayIndexBeginning + forwardIndex] == subset[forwardIndex] && array[arrayIndex - arrayOffset] == subset[reverseIndex]) {
                    ++forwardIndex;
                    --reverseIndex;
                    ++arrayOffset;
                }
                if (forwardIndex >= reverseIndex) {
                    return arrayIndex - SUBSET_LENGTH;
                }
            }
            ++arrayIndex;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String element, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (element.equalsIgnoreCase(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean[] reverse(boolean[] array) {
        boolean[] reverse = new boolean[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static byte[] reverse(byte[] array) {
        byte[] reverse = new byte[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static char[] reverse(char[] array) {
        char[] reverse = new char[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static short[] reverse(short[] array) {
        short[] reverse = new short[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static int[] reverse(int[] array) {
        int[] reverse = new int[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static long[] reverse(long[] array) {
        long[] reverse = new long[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static float[] reverse(float[] array) {
        float[] reverse = new float[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static double[] reverse(double[] array) {
        double[] reverse = new double[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static Object[] reverse(Object[] array) {
        Object[] reverse = new Object[array.length];
        int i = 0;
        int j = array.length - 1;
        while (i <= j) {
            reverse[i] = array[j];
            reverse[j] = array[i];
            ++i;
            --j;
        }
        return reverse;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(byte[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(char[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean[] shiftLeft(boolean[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        boolean[] newArray = new boolean[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static byte[] shiftLeft(byte[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        byte[] newArray = new byte[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static short[] shiftLeft(short[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        short[] newArray = new short[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static char[] shiftLeft(char[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        char[] newArray = new char[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static int[] shiftLeft(int[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        int[] newArray = new int[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static long[] shiftLeft(long[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        long[] newArray = new long[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static float[] shiftLeft(float[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        float[] newArray = new float[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static double[] shiftLeft(double[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        double[] newArray = new double[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static <T> T[] shiftLeft(T[] array) {
        if (ArrayUtility.isEmpty(array)) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array[0].getClass(), array.length - 1);
        System.arraycopy(array, 1, newArray, 0, newArray.length);
        return newArray;
    }

    public static int compareTo(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return 0;
        }
        if (array1 == null && array2 != null) {
            return -1;
        }
        if (array1 != null && array2 == null) {
            return 1;
        }
        if (array1.length == 0 && array2.length == 0) {
            return 0;
        }
        ArrayList<Object> c1 = new ArrayList<Object>(Arrays.asList(array1));
        ArrayList<Object> c2 = new ArrayList<Object>(Arrays.asList(array2));
        CollectionComparator<Object> cc = new CollectionComparator<Object>();
        return cc.compare(c1, c2);
    }

    public static byte[] interleave(byte[] ... bytes) {
        int[] lengths = new int[bytes.length];
        int i = 0;
        int interleaveLength = 0;
        int maxLength = 0;
        byte[][] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] b = byArray[n2];
            int l = b.length;
            interleaveLength += l;
            if (l > maxLength) {
                maxLength = l;
            }
            lengths[i++] = l;
            ++n2;
        }
        byte[] interleave = new byte[interleaveLength];
        int[] lastInterleaveRatios = new int[bytes.length];
        i = 0;
        while (i < lengths.length) {
            lastInterleaveRatios[i] = (int)Math.round((double)maxLength / (double)lengths[i]);
            ++i;
        }
        int[] bytePtr = new int[bytes.length];
        int ic = 0;
        i = 0;
        while (i < interleaveLength) {
            int s = 0;
            while (s < bytes.length) {
                if (i % lastInterleaveRatios[s] == 0 && bytePtr[s] < lengths[s]) {
                    interleave[ic++] = bytes[s][bytePtr[s]];
                    int n3 = s;
                    bytePtr[n3] = bytePtr[n3] + 1;
                }
                ++s;
            }
            ++i;
        }
        return interleave;
    }

    public static byte[] deinterleaveFrom(byte[] interleaved, byte[] extract) {
        int finalLength = interleaved.length - extract.length;
        int extractRatio = (int)Math.round((double)interleaved.length / (double)extract.length);
        byte[] original = new byte[finalLength];
        original[0] = interleaved[0];
        int i = 1;
        int o = 1;
        int e = 0;
        while (i < interleaved.length && o < finalLength) {
            if (e < extract.length && i % extractRatio == 1) {
                ++e;
            } else {
                original[o++] = interleaved[i];
            }
            ++i;
        }
        return original;
    }

    public static char[] interleave(char[] ... strings) {
        int[] lengths = new int[strings.length];
        int i = 0;
        int interleaveLength = 0;
        int maxLength = 0;
        char[][] cArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            char[] s = cArray[n2];
            int l = s.length;
            interleaveLength += l;
            if (l > maxLength) {
                maxLength = l;
            }
            lengths[i++] = l;
            ++n2;
        }
        char[] interleave = new char[interleaveLength];
        int[] lastInterleaveRatios = new int[strings.length];
        i = 0;
        while (i < lengths.length) {
            lastInterleaveRatios[i] = (int)Math.round((double)maxLength / (double)lengths[i]);
            ++i;
        }
        int[] charPtr = new int[strings.length];
        int ic = 0;
        i = 0;
        while (i < interleaveLength) {
            int s = 0;
            while (s < strings.length) {
                int modI;
                int n3 = modI = lastInterleaveRatios[s] == 0 ? 0 : i % lastInterleaveRatios[s];
                if (modI == 0 && charPtr[s] < lengths[s]) {
                    interleave[ic++] = strings[s][charPtr[s]];
                    int n4 = s;
                    charPtr[n4] = charPtr[n4] + 1;
                }
                ++s;
            }
            ++i;
        }
        return interleave;
    }
}

