/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import java.util.Arrays;
import java.util.Calendar;

public class ChronologicalTabulationEntry {
    public static final int SECOND = 0;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY_OF_MONTH = 3;
    public static final int DAY_OF_WEEK = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    private boolean[] second = new boolean[60];
    private boolean[] minute = new boolean[60];
    private boolean[] hour = new boolean[24];
    private boolean[] dayOfMonth = new boolean[32];
    private boolean[] dayOfWeek = new boolean[8];
    private boolean[] month = new boolean[12];
    private int[] year;
    private int baseYear = Calendar.getInstance().get(1);
    private int yearMultiplier = 1;

    public ChronologicalTabulationEntry() {
        ChronologicalTabulationEntry.fillSet(this.second, true);
        ChronologicalTabulationEntry.fillSet(this.minute, true);
        ChronologicalTabulationEntry.fillSet(this.hour, true);
        ChronologicalTabulationEntry.fillSet(this.dayOfMonth, true);
        ChronologicalTabulationEntry.fillSet(this.dayOfWeek, true);
        ChronologicalTabulationEntry.fillSet(this.month, true);
        this.dayOfMonth[0] = false;
        this.dayOfWeek[0] = false;
    }

    public boolean isTimeValid(Calendar refTime) {
        return this.second[refTime.get(13)] && this.minute[refTime.get(12)] && this.hour[ChronologicalTabulationEntry.getHour(refTime)] && this.dayOfMonth[refTime.get(5)] && this.dayOfWeek[refTime.get(7)] && this.month[refTime.get(2)] && this.isYearValid(refTime.get(1));
    }

    public Calendar getNextTime(Calendar refTime) {
        int clockhour;
        Calendar thisTime = (Calendar)refTime.clone();
        Calendar nextTime = (Calendar)refTime.clone();
        thisTime.add(13, 1);
        nextTime.add(13, 1);
        if (!this.second[nextTime.get(13)]) {
            nextTime.add(13, this.getCountToNextEntry(this.second, nextTime.get(13)));
        }
        if (!this.minute[nextTime.get(12)]) {
            nextTime.add(12, this.getCountToNextEntry(this.minute, nextTime.get(12)));
            nextTime.set(13, ChronologicalTabulationEntry.getEarliestElement(this.second));
        }
        if (!this.hour[clockhour = ChronologicalTabulationEntry.getHour(nextTime)]) {
            nextTime.add(10, this.getCountToNextEntry(this.hour, clockhour));
            nextTime.set(12, ChronologicalTabulationEntry.getEarliestElement(this.minute));
            nextTime.set(13, ChronologicalTabulationEntry.getEarliestElement(this.second));
        }
        if (!this.dayOfWeek[nextTime.get(7)]) {
            nextTime.add(7, this.getCountToNextEntry(this.dayOfWeek, nextTime.get(7)));
            nextTime.set(10, ChronologicalTabulationEntry.getEarliestElement(this.hour));
            nextTime.set(12, ChronologicalTabulationEntry.getEarliestElement(this.minute));
            nextTime.set(13, ChronologicalTabulationEntry.getEarliestElement(this.second));
        }
        if (!this.dayOfMonth[nextTime.get(5)]) {
            nextTime.add(5, this.getCountToNextDOM(nextTime.get(5), nextTime));
            nextTime.set(10, ChronologicalTabulationEntry.getEarliestElement(this.hour));
            nextTime.set(12, ChronologicalTabulationEntry.getEarliestElement(this.minute));
            nextTime.set(13, ChronologicalTabulationEntry.getEarliestElement(this.second));
        }
        if (!this.month[nextTime.get(2)]) {
            nextTime.add(2, this.getCountToNextEntry(this.month, nextTime.get(2)));
            nextTime.set(5, ChronologicalTabulationEntry.getEarliestElement(this.dayOfMonth));
            nextTime.set(10, ChronologicalTabulationEntry.getEarliestElement(this.hour));
            nextTime.set(12, ChronologicalTabulationEntry.getEarliestElement(this.minute));
            nextTime.set(13, ChronologicalTabulationEntry.getEarliestElement(this.second));
        }
        if (!this.isYearValid(nextTime.get(1))) {
            nextTime.add(1, this.getCountToNextYear(nextTime.get(1)));
            nextTime.set(2, ChronologicalTabulationEntry.getEarliestElement(this.month));
            nextTime.set(5, ChronologicalTabulationEntry.getEarliestElement(this.dayOfMonth));
            nextTime.set(10, ChronologicalTabulationEntry.getEarliestElement(this.hour));
            nextTime.set(12, ChronologicalTabulationEntry.getEarliestElement(this.minute));
            nextTime.set(13, ChronologicalTabulationEntry.getEarliestElement(this.second));
        }
        return nextTime;
    }

    private boolean isYearValid(int year) {
        if (this.year == null) {
            int aYear = this.baseYear;
            while (aYear < year) {
                aYear += this.yearMultiplier;
            }
            return aYear == year;
        }
        int i = 0;
        while (i < this.year.length) {
            if (this.year[i] == year) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static int getHour(Calendar time) {
        int clockhour = time.get(10);
        if (time.get(9) == 1) {
            clockhour += 12;
        }
        return clockhour;
    }

    private int getCountToNextEntry(boolean[] index, int startPoint) {
        int n = 1;
        int i = startPoint + 1;
        while (i < index.length) {
            if (index[i]) {
                return n;
            }
            ++i;
            ++n;
        }
        if (index == this.dayOfWeek) {
            --n;
        }
        i = 0;
        while (i <= startPoint) {
            if (index[i]) {
                return n;
            }
            ++i;
            ++n;
        }
        return n;
    }

    private int getCountToNextDOM(int day, Calendar ref) {
        int lastDOM = ref.getActualMaximum(5);
        int n = 1;
        int i = day + 1;
        while (i <= lastDOM) {
            if (this.dayOfMonth[i]) {
                return n;
            }
            ++i;
            ++n;
        }
        i = 1;
        while (i <= day) {
            if (this.dayOfMonth[i]) {
                return n;
            }
            ++i;
            ++n;
        }
        return n;
    }

    private int getCountToNextYear(int year) {
        if (this.year == null) {
            int aYear = this.baseYear;
            while (aYear <= year) {
                aYear += this.yearMultiplier;
            }
            return aYear - year;
        }
        int i = 0;
        while (this.year[i] <= year) {
            ++i;
        }
        if (i > this.year.length) {
            return 0;
        }
        return this.year[i] - year;
    }

    private static int getEarliestElement(boolean[] set) {
        int i = 0;
        while (i < set.length) {
            if (set[i]) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void set(int setting, int index, boolean state) {
        switch (setting) {
            case 0: {
                ChronologicalTabulationEntry.set(this.second, index, state, 0, 59);
                break;
            }
            case 1: {
                ChronologicalTabulationEntry.set(this.minute, index, state, 0, 59);
                break;
            }
            case 2: {
                ChronologicalTabulationEntry.set(this.hour, index, state, 0, 23);
                break;
            }
            case 3: {
                ChronologicalTabulationEntry.set(this.dayOfMonth, index, state, 0, 31);
                break;
            }
            case 4: {
                ChronologicalTabulationEntry.set(this.dayOfWeek, index, state, 0, 6);
                break;
            }
            case 5: {
                ChronologicalTabulationEntry.set(this.month, index, state, 0, 11);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The provided setting cannot be resolved.");
            }
        }
    }

    private static void set(boolean[] set, int index, boolean state, int min, int max) {
        ChronologicalTabulationEntry.validateIndex(index, min, max);
        if (state) {
            ChronologicalTabulationEntry.fillSet(set, false);
        }
        set[index] = state;
    }

    public void set(int setting, int[] index, boolean state) {
        switch (setting) {
            case 0: {
                ChronologicalTabulationEntry.set(this.second, index, state, 0, 59);
                break;
            }
            case 1: {
                ChronologicalTabulationEntry.set(this.minute, index, state, 0, 59);
                break;
            }
            case 2: {
                ChronologicalTabulationEntry.set(this.hour, index, state, 0, 23);
                break;
            }
            case 4: {
                ChronologicalTabulationEntry.set(this.dayOfWeek, index, state, 0, 6);
                break;
            }
            case 3: {
                ChronologicalTabulationEntry.set(this.dayOfMonth, index, state, 0, 31);
                break;
            }
            case 5: {
                ChronologicalTabulationEntry.set(this.month, index, state, 0, 11);
                break;
            }
            case 6: {
                this.setYear(index);
                break;
            }
            default: {
                throw new IllegalArgumentException("The provided setting cannot be resolved.");
            }
        }
    }

    private static void set(boolean[] set, int[] index, boolean state, int min, int max) {
        int i = 0;
        while (i < index.length) {
            ChronologicalTabulationEntry.validateIndex(index[i], min, max);
            ++i;
        }
        if (state) {
            ChronologicalTabulationEntry.fillSet(set, false);
        }
        i = 0;
        while (i < index.length) {
            set[index[i]] = state;
            ++i;
        }
    }

    private static void validateIndex(int index, int min, int max) {
        if (index < min || index > max) {
            throw new IllegalArgumentException("Cannot use the given index of " + index + ". It must be in a range from " + min + " to " + max + ".");
        }
    }

    public void set(int setting, boolean state) {
        switch (setting) {
            case 0: {
                ChronologicalTabulationEntry.fillSet(this.second, true);
                break;
            }
            case 1: {
                ChronologicalTabulationEntry.fillSet(this.minute, true);
                break;
            }
            case 2: {
                ChronologicalTabulationEntry.fillSet(this.hour, true);
                break;
            }
            case 4: {
                ChronologicalTabulationEntry.fillSet(this.dayOfWeek, true);
                break;
            }
            case 3: {
                ChronologicalTabulationEntry.fillSet(this.dayOfMonth, true);
                break;
            }
            case 5: {
                ChronologicalTabulationEntry.fillSet(this.month, true);
                break;
            }
            case 6: {
                throw new RuntimeException("Use setYear(int year) instead.");
            }
            default: {
                throw new IllegalArgumentException("The provided setting cannot be resolved.");
            }
        }
    }

    private static void fillSet(boolean[] set, boolean state) {
        int i = 0;
        while (i < set.length) {
            set[i] = state;
            ++i;
        }
    }

    public void setYear(int year) {
        this.setYear(year, 0);
    }

    public void setYear(int startYear, int frequency) {
        this.baseYear = startYear;
        this.yearMultiplier = frequency;
        this.year = null;
    }

    public void setYear(int[] years) {
        this.year = years;
        Arrays.sort(this.year);
    }
}

