/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.util.CrossReferenceMember;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;

public class CrossReference {
    private ArrayList<CrossReferenceMember> classToPackage = new ArrayList();
    private ArrayList<CrossReferenceMember> methodToClass = new ArrayList();
    private ArrayList<CrossReferenceMember> fieldToClass = new ArrayList();
    private ArrayList<CrossReferenceMember> interfaceToClass = new ArrayList();

    public CrossReference(String beginningDirectory) {
        File dir = new File(beginningDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("The argument " + beginningDirectory + " does not exist or is not a directory");
        }
        this.workDirectory(dir);
        this.outputResults();
    }

    private void workDirectory(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory() && files[i].getName().toLowerCase().endsWith(".java")) {
                String className = CrossReference.getClassName(files[i]);
                String packageName = CrossReference.getPackageName(files[i]);
                String fullClassName = packageName.length() == 0 ? className : packageName + "." + className;
                this.processClass(fullClassName);
            }
            ++i;
        }
        i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.workDirectory(files[i]);
            }
            ++i;
        }
    }

    private void processClass(String fullClassName) {
        try {
            Class<?> classInfo = Class.forName(fullClassName);
            String className = classInfo.getName();
            Package packageInst = classInfo.getPackage();
            String packageName = "{default}";
            if (packageInst != null) {
                packageName = packageInst.getName();
            }
            this.classToPackage.add(new CrossReferenceMember(classInfo, packageName, classInfo.getModifiers()));
            this.processClassMethods(classInfo, className);
            this.processClassFields(classInfo, className);
            this.processClassInterfaces(classInfo, className);
        }
        catch (ClassNotFoundException cnfEx) {
            System.err.println("Class " + fullClassName + " was not found.");
        }
        catch (NoClassDefFoundError ncEx) {
            System.err.println("Class " + fullClassName + " definition was not found.");
        }
    }

    private void processClassInterfaces(Class<?> classInfo, String className) {
        Class<?>[] interfaces = classInfo.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.interfaceToClass.add(new CrossReferenceMember(interfaces[i], className, interfaces[i].getModifiers()));
            ++i;
        }
    }

    private void processClassMethods(Class<?> classInfo, String className) {
        Method[] methods = classInfo.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            this.methodToClass.add(new CrossReferenceMember(methods[i], className, methods[i].getModifiers()));
            ++i;
        }
    }

    private void processClassFields(Class<?> classInfo, String className) {
        Field[] fields = classInfo.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            this.fieldToClass.add(new CrossReferenceMember(fields[i], className, fields[i].getModifiers()));
            ++i;
        }
    }

    private static String getClassName(File file) {
        String fileName = file.getName();
        return fileName.substring(0, fileName.length() - 5);
    }

    private static String getPackageName(File file) {
        block18: {
            FileReader fr = null;
            BufferedReader lr = null;
            try {
                String line;
                fr = new FileReader(file);
                lr = new LineNumberReader(fr);
                do {
                    if ((line = ((LineNumberReader)lr).readLine()) != null) continue;
                    break block18;
                } while (!(line = line.trim()).startsWith("package "));
                int semiLocation = line.indexOf(59);
                String string = line = line.substring(8, semiLocation);
                return string;
            }
            catch (FileNotFoundException fnfEx) {
                System.err.println("Cannot find file: " + String.valueOf(file.getAbsoluteFile()));
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            finally {
                try {
                    lr.close();
                    fr.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.err.println("Package not found in : " + String.valueOf(file.getAbsoluteFile()));
        return "";
    }

    private void outputResults() {
        CrossReference.outputList("Class", "Package", this.classToPackage);
        CrossReference.outputList("Method", "Class", this.methodToClass);
        CrossReference.outputList("Field", "Class", this.fieldToClass);
        CrossReference.outputList("Interface", "Class", this.interfaceToClass);
    }

    private static void outputList(String fromRef, String toRef, ArrayList<CrossReferenceMember> list) {
        Collections.sort(list);
        String fileName = "/home/josephmmorgan/development/docs/Framework/" + fromRef + "to" + toRef + ".html";
        System.out.println("Writing " + fileName);
        try {
            PrintStream originalOut = System.out;
            FileOutputStream fos = new FileOutputStream(fileName);
            PrintStream ps = new PrintStream(fos);
            System.setOut(ps);
            String title = fromRef + " to " + toRef + " Cross Reference";
            System.out.println("<html><body><center>");
            System.out.println("<table border=1><tr><th colspan=8>Icon Legend</th></tr>");
            System.out.println("<tr><td><img src='publicVisibility.gif'></td><td>Public Visibility</td>");
            System.out.println("<td><img src='protectedVisibility.gif'></td><td>Protected Visibility</td>");
            System.out.println("<td><img src='defaultVisibility.gif'></td><td>Package (default) Visibility</td>");
            System.out.println("<td><img src='privateVisibility.gif'></td><td>Private Visibility</td></tr>");
            System.out.println("<tr><td colspan=2><img src='classScope.gif'></td><td colspan=2>Class Scope (static)</td>");
            System.out.println("<td colspan=2><img src='instanceScope.gif'></td><td colspan=2>Instance Scope</td></tr>");
            System.out.println("<tr><td colspan=2><img src='normalState.gif'></td><td colspan=2>Not Final - Can be extended/overridden</td>");
            System.out.println("<td colspan=2><img src='finalState.gif'></td><td colspan=2>Final - Cannot be extended/overridden</td></tr>");
            System.out.println("</table>");
            System.out.println("<table border=1><tr><th colspan=5 bgColor=\"#ffffaa\">" + title + "</th></tr>");
            System.out.println("<tr bgColor=\"#00ffaa\"><th colspan=3>Mods</th><th>" + fromRef + "</th><th>" + toRef + "</th></tr>");
            int lineNo = 1;
            String bgColor = "";
            for (CrossReferenceMember cr : list) {
                bgColor = lineNo % 2 == 0 ? "#dddddd" : "white";
                System.out.println("<tr valign=top bgColor=\"" + bgColor + "\">" + String.valueOf(cr) + "</tr>");
                ++lineNo;
            }
            System.out.println("</table></center></body></html>");
            ps.flush();
            ps.close();
            fos.close();
            System.setOut(originalOut);
        }
        catch (IOException ioEx) {
            System.err.println("The File " + fileName + " cannot be created.");
        }
    }

    public static void main(String[] args) {
        new CrossReference("/home/josephmmorgan/development/java/Projects/Framework/");
    }
}

