/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CrossReferenceMember
implements Comparable<CrossReferenceMember> {
    private Object key;
    private String keyName;
    private String reference;
    private int modifiers;

    public CrossReferenceMember(Object key, String reference, int modifiers) {
        if (key instanceof Class) {
            Package pkg = ((Class)key).getPackage();
            if (pkg == null) {
                this.keyName = ((Class)key).getName();
            } else {
                String pkgName = pkg.getName();
                this.keyName = ((Class)key).getName();
                this.keyName = this.keyName.substring(pkgName.length() + 1);
            }
        }
        if (key instanceof Member) {
            this.keyName = ((Member)key).getName();
        }
        this.key = key;
        this.reference = reference;
        this.modifiers = modifiers;
    }

    public Object getKey() {
        return this.key;
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public int compareTo(CrossReferenceMember that) {
        int keyNameCmp;
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        if (this.key instanceof Member) {
            Member thisKey = (Member)this.key;
            Member thatKey = (Member)that.getKey();
            int keyCmp = thisKey.getName().compareTo(thatKey.getName());
            if (keyCmp != 0) {
                return keyCmp;
            }
        }
        if (this.key instanceof Class && (keyNameCmp = this.keyName.compareTo(that.keyName)) != 0) {
            return keyNameCmp;
        }
        return this.reference.compareTo(that.reference);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof CrossReferenceMember) {
            CrossReferenceMember that = (CrossReferenceMember)o;
            return this.keyName.equals(that.keyName) && this.reference.equals(that.reference);
        }
        return false;
    }

    public String toString() {
        String visibilityPicture = "defaultVisibility.gif";
        String scopePicture = "instanceScope.gif";
        String statePicture = "normalState.gif";
        Object keyDef = this.keyName;
        if (Modifier.isPublic(this.modifiers)) {
            visibilityPicture = "publicVisibility.gif";
        }
        if (Modifier.isProtected(this.modifiers)) {
            visibilityPicture = "protectedVisibility.gif";
        }
        if (Modifier.isPrivate(this.modifiers)) {
            visibilityPicture = "privateVisibility.gif";
        }
        if (Modifier.isStatic(this.modifiers)) {
            scopePicture = "classScope.gif";
        }
        if (Modifier.isAbstract(this.modifiers)) {
            statePicture = "abstractState.gif";
        }
        if (Modifier.isFinal(this.modifiers)) {
            statePicture = "finalState.gif";
        }
        if (this.key instanceof Method) {
            Class<?>[] exceptTypes;
            Method method = (Method)this.key;
            keyDef = (String)keyDef + " : <font color=blue>" + this.getType(method.getReturnType().getName()) + "</font>";
            Class<?>[] parmTypes = method.getParameterTypes();
            if (parmTypes.length > 0) {
                keyDef = (String)keyDef + "<br><table border=0 style=\"position: relative; left: 30; color: green;\">";
                keyDef = (String)keyDef + "<tr><th>Parameters</th></tr>";
                int i = 0;
                while (i < parmTypes.length) {
                    keyDef = (String)keyDef + "<tr><td>" + this.getType(parmTypes[i].getName()) + "</td></tr>";
                    ++i;
                }
                keyDef = (String)keyDef + "</table>";
            }
            if ((exceptTypes = method.getExceptionTypes()).length > 0) {
                keyDef = (String)keyDef + "<table border=0 style=\"position: relative; left: 30; color: red;\">";
                keyDef = (String)keyDef + "<tr><th>Exceptions</th></tr>";
                int i = 0;
                while (i < exceptTypes.length) {
                    keyDef = (String)keyDef + "<tr><td>" + exceptTypes[i].getName() + "</td></tr>";
                    ++i;
                }
                keyDef = (String)keyDef + "</table>";
            }
        }
        if (this.key instanceof Field) {
            Field field = (Field)this.key;
            keyDef = (String)keyDef + " : <font color=blue>" + this.getType(field.getType().getName()) + "</font>";
        }
        return "<td><img src=\"" + visibilityPicture + "\"></td><td><img src=\"" + scopePicture + "\"></td><td><img src=\"" + statePicture + "\"></td><td>" + (String)keyDef + "</td><td>" + this.reference + "</td>";
    }

    private String getType(String type) {
        if (((String)type).charAt(0) == '[') {
            switch (((String)type).charAt(1)) {
                case '[': {
                    type = this.getType(((String)type).substring(1)) + "[]";
                    break;
                }
                case 'B': {
                    type = "byte[]";
                    break;
                }
                case 'C': {
                    type = "char[]";
                    break;
                }
                case 'F': {
                    type = "float[]";
                    break;
                }
                case 'D': {
                    type = "double[]";
                    break;
                }
                case 'I': {
                    type = "int[]";
                    break;
                }
                case 'J': {
                    type = "long[]";
                    break;
                }
                case 'L': {
                    type = ((String)type).substring(2, ((String)type).length() - 1) + "[]";
                    break;
                }
                case 'S': {
                    type = "short[]";
                    break;
                }
                case 'Z': {
                    type = "boolean[]";
                    break;
                }
                default: {
                    System.err.println("Type : " + (String)type + " not accounted for CrossReferenceMember.getType()");
                }
            }
        }
        return type;
    }
}

